% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-biomass.R
\name{silv_predict_biomass}
\alias{silv_predict_biomass}
\title{Calculate Tree Biomass}
\usage{
silv_predict_biomass(
  diameter = NULL,
  height = NULL,
  model,
  ntrees = NULL,
  quiet = FALSE
)
}
\arguments{
\item{diameter}{A numeric vector of tree diameters (in cm).}

\item{height}{A numeric vector of tree heights (in m).}

\item{model}{A function. A function with the structure \code{eq_biomass_*()} with
additional arguments depending on the model used.}

\item{ntrees}{An optional numeric value indicating the number of trees in
this diameter-height class. Defaults to 1 if \code{NULL}.}

\item{quiet}{A logical value. If \code{TRUE}, suppresses any informational messages.}
}
\value{
A numeric vector
}
\description{
Computes the biomass of a tree species using species-specific allometric
equations (in kg). Currently, only equations for Spain are available.
}
\details{
The function estimates biomass using validated allometric models available in the
dataset \link{biomass_models}. The available models include:
\itemize{
\item \strong{\code{\link[=eq_biomass_ruiz_peinado_2011]{eq_biomass_ruiz_peinado_2011()}}}: Developed for softwood species in Spain.
\item \strong{\code{\link[=eq_biomass_ruiz_peinado_2012]{eq_biomass_ruiz_peinado_2012()}}}: Developed for hardwood species in Spain.
}

Users can check the list of supported species and their corresponding components
in \link{biomass_models}.

If you would like to suggest additional models, please open a new issue on GitHub.
}
\examples{
# Calculate biomass for a single tree
silv_predict_biomass(
  diameter = 45,
  height   = 22,
  model    = eq_biomass_ruiz_peinado_2011("Pinus pinaster")
)
}
\seealso{
\link{biomass_models}, \code{\link[=eq_biomass_montero_2005]{eq_biomass_montero_2005()}}, \code{\link[=eq_biomass_dieguez_aranda_2009]{eq_biomass_dieguez_aranda_2009()}},
\code{\link[=eq_biomass_ruiz_peinado_2011]{eq_biomass_ruiz_peinado_2011()}}, \code{\link[=eq_biomass_ruiz_peinado_2012]{eq_biomass_ruiz_peinado_2012()}}, \code{\link[=eq_biomass_manrique_2017]{eq_biomass_manrique_2017()}},
\code{\link[=eq_biomass_menendez_2022]{eq_biomass_menendez_2022()}}, \code{\link[=eq_biomass_cudjoe_2024]{eq_biomass_cudjoe_2024()}}
}
