% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterCalculation_h0.R
\name{parameterCalculation_h0}
\alias{parameterCalculation_h0}
\title{additional parameter calculation with help of fits}
\usage{
parameterCalculation_h0(parameterVector, stepSize = 1e-05)
}
\arguments{
\item{parameterVector}{Output of multiple fit function sicegar::multipleFitFunction() that gives the variables generated by the sigmoidal or double sigmoidal fit.}

\item{stepSize}{Step size used by the fitting algorithm. Smaller numbers gave more accurate results than larger numbers, and larger numbers gave the results faster than small numbers. The default value is 0.00001.}
}
\value{
Returns the expanded parameter vector. This vector includes useful derived values such as time and intensity of the start point, in addition to the standard values that the fit algorithms produce that are necessary to define the curves.
}
\description{
Generates useful values for external use, using parameters existing in the parameterVector.
}
\examples{
# runif() is used here for consistency with previous versions of the sicegar package. However,
# rnorm() will generate symmetric errors, producing less biased numerical parameter estimates.
# We recommend errors generated with rnorm() for any simulation studies on sicegar.
time <- seq(3, 24, 0.1)

#simulate intensity data with noise
noise_parameter <- 0.2
intensity_noise <- stats::runif(n = length(time), min = 0, max = 1) * noise_parameter
intensity <- sicegar::doublesigmoidalFitFormula_h0(time,
                                            finalAsymptoteIntensityRatio = .3,
                                            maximum = 4,
                                            slope1Param = 1,
                                            midPoint1Param = 7,
                                            slope2Param = 1,
                                            midPointDistanceParam = 8,
                                            h0 = 1)
intensity <- intensity+intensity_noise

dataInput <- data.frame(intensity = intensity, time = time)
normalizedInput <- sicegar::normalizeData(dataInput)
parameterVector <- sicegar::multipleFitFunction_h0(dataInput = normalizedInput,
                                            dataInputName = "sample01",
                                            model = "doublesigmoidal",
                                            n_runs_min = 20,
                                            n_runs_max = 500,
                                            showDetails = FALSE)

if(parameterVector$isThisaFit){
       parameterVector <- sicegar::parameterCalculation_h0(parameterVector)
}

print(t(parameterVector))

}
