% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WriteToFiles.R
\name{writeSeq}
\alias{writeSeq}
\title{Write Sequoia Output to File}
\usage{
writeSeq(
  SeqList,
  GenoM = NULL,
  MaybeRel = NULL,
  PedComp = NULL,
  OutFormat = "txt",
  folder = "Sequoia-OUT",
  file = "Sequoia-OUT.xlsx",
  quiet = FALSE
)
}
\arguments{
\item{SeqList}{list returned by \code{\link{sequoia}}, to be written out.}

\item{GenoM}{matrix with genetic data (optional). Ignored if
OutFormat='xls', as the resulting file could become too large for excel.}

\item{MaybeRel}{list with results from \code{\link{GetMaybeRel}} (optional).}

\item{PedComp}{list with results from \code{\link{PedCompare}} (optional).
\code{SeqList$DummyIDs} is combined with \code{PedComp$DummyMatch} if both
are provided.}

\item{OutFormat}{'xls' or 'txt'.}

\item{folder}{the directory where the text files will be written; will be
created if it does not already exists. Relative to the current working
directory, or NULL for current working directory. Ignored if
\code{OutFormat='xls'}.}

\item{file}{the name of the excel file to write to, ignored if
\code{OutFormat='txt'}.}

\item{quiet}{suppress messages.}
}
\description{
The various list elements returned by \code{sequoia} are each
  written to text files in the specified folder, or to separate sheets in a
  single excel file (requires library \pkg{openxlsx}).
}
\details{
The text files can be used as input for the stand-alone Fortran
  version of sequoia, e.g. when the genotype data is too large for R. See
  \code{vignette('sequoia')} for further details.
}
\examples{
\dontrun{
writeSeq(SeqList, OutFormat="xls", file="MyFile.xlsx")

# add additional sheet to the excel file:
library(openxlsx)
wb <- loadWorkbook("MyFile.xlsx")
addWorksheet(wb, sheetName = "ExtraData")
writeData(wb, sheet = "ExtraData", MyData, rowNames=FALSE)
saveWorkbook(wb, "MyFile.xlsx", overwrite=TRUE, returnValue=TRUE)

# or: (package requires java & is trickier to install)
xlsx::write.xlsx(MyData, file = "MyFile.xlsx", sheetName="ExtraData",
      col.names=TRUE, row.names=FALSE, append=TRUE, showNA=FALSE)
}

}
\seealso{
\code{\link{writeColumns}} to write to a text file, using white
  space padding to keep columns aligned.
}
