% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivityIxJ.R
\name{exact.general.sen.IxJ}
\alias{exact.general.sen.IxJ}
\title{Exact Sensitivity Analysis for General Test Statistics in I by J Tables}
\usage{
exact.general.sen.IxJ(
  u_space = NULL,
  obs.table,
  table_space,
  gamma,
  delta,
  row = "treatment",
  verbose = FALSE
)
}
\arguments{
\item{u_space}{A matrix where each row represents a unique allocation of \code{u_i=1} across outcomes.
If \code{NULL}, the function generates a default set of corner allocations based on
the number of outcomes. Defaults to \code{NULL}.}

\item{obs.table}{A matrix or table object representing the observed contingency table.}

\item{table_space}{A list of matrices or table objects representing the space of contingency
tables to consider (typically all tables with test statistic >= observed).}

\item{gamma}{A scalar}

\item{delta}{A binary vector with no more than two unique values, corresponding to treatment levels.
The length must match the number of treatments (rows of \code{obs.table} if \code{row = "treatment"},
or columns if \code{row = "outcome"}).}

\item{row}{A string indicating whether rows represent "outcome" or "treatment".
Must be either "outcome" or "treatment". Default is "treatment".}

\item{verbose}{A logical flag indicating whether to print progress messages showing the
current maximizer and probability at each step. Default is \code{FALSE}.}
}
\value{
A list containing:
\describe{
\item{rct.prob}{Probability under Randomized Controlled Trial (RCT) with \code{u_allocation} set to zero.}
\item{max.prob}{Maximum probability found across all allocations in \code{u_space}.}
\item{maximizer}{The \code{u_allocation} vector that yields \code{max.prob}.}
\item{gamma}{Extracted gamma value from the generic bias model.}
\item{delta}{remind the practitioners of their delta}
}
}
\description{
This function computes exact p-values for sensitivity analysis in I by J contingency tables
under the generic bias model. It enumerates all tables in the reference set and
calculates the maximum p-value over the sensitivity parameter space (u allocations).
The function is designed for general permutation-invariant test statistics.
}
\details{
The function performs exact sensitivity analysis by:
\enumerate{
\item Enumerating all possible u allocations (or using provided u_space)
\item Computing the p-value for each allocation by summing probabilities over table_space
\item Finding the allocation that maximizes the p-value
}

For computational efficiency, the function only supports certain table dimensions.
If u_space is not provided, default corner allocations are generated for J <= 5.
}
\examples{
\donttest{
## Example 1: 3 by 3 table with custom test statistic
# Create an observed table (example data)
obs.table <- matrix(c(5, 3, 2, 6, 11, 7, 3, 0, 3), ncol = 3, byrow = TRUE)

# Define a test statistic emphasizing certain cells
transform.fun <- function(tb){
  test.stat <- 4 * tb[3, 3] + 3 * tb[2, 3]
  return(test.stat)
}
obs.stat <- transform.fun(obs.table)

# Find the reference set (tables with test statistic >= observed)
table.set <- possible.table(
  threshold = obs.stat,
  table = obs.table,
  direction = "greater than",
  transform.fun = transform.fun
)

# Perform sensitivity analysis
sen.result <- exact.general.sen.IxJ(
  obs.table = obs.table,
  table_space = table.set,
  gamma = 0.5,
  delta = c(0, 1, 1)
)
sen.result
}

}
