% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Seurat.R
\name{ElbowPlot_scCustom}
\alias{ElbowPlot_scCustom}
\title{ElbowPlot with modifications}
\usage{
ElbowPlot_scCustom(
  seurat_object,
  ndims = NULL,
  reduction = "pca",
  calc_cutoffs = TRUE,
  plot_cutoffs = TRUE,
  line_colors = c("dodgerblue", "firebrick"),
  linewidth = 0.5
)
}
\arguments{
\item{seurat_object}{name of Seurat object}

\item{ndims}{The number of dims to plot.  Default is NULL and will plot all dims}

\item{reduction}{The reduction to use, default is "pca"}

\item{calc_cutoffs}{logical, whether or not to calculate the cutoffs, default is TRUE.}

\item{plot_cutoffs}{lgoical, whether to plot the cutoffs as vertical lines on plot, default is TRUE.}

\item{line_colors}{colors for the cutoff lines, default is c("dodgerblue", "firebrick").}

\item{linewidth}{widith of the cutoff lines, default is 0.5.}
}
\value{
ggplot2 object
}
\description{
Creates ElbowPlot with ability to calculate and plot cutoffs for amount of variance conferred by the PCs.
Cutoff 1 is PC where principal components only contribute less than 5\% of standard deviation and the principal components
cumulatively contribute 90\% of the standard deviation.
Cutoff 2 is point where the percent change in variation between the consecutive PCs is less than 0.1\%.
}
\examples{
library(Seurat)
ElbowPlot_scCustom(seurat_object = pbmc_small)

}
\references{
Modified from following: \url{https://hbctraining.github.io/scRNA-seq/lessons/elbow_plot_metric.html}.
}
\concept{seurat_plotting}
