% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getColoursHardness.R
\name{getColoursHardness}
\alias{getColoursHardness}
\title{Gets colours for plotting snow hardness values}
\usage{
getColoursHardness(Values, Resolution = 101, Verbose = FALSE)
}
\arguments{
\item{Values}{Hardness values}

\item{Resolution}{Resolution of colour scale. Default is 100.}

\item{Verbose}{Switch for writing out value and html colour tuplets for debugging.}
}
\value{
Array with HTML colour codes
}
\description{
Gets colours for plotting snow hardness values in snowprofiles.
}
\examples{

Hardness <- c(1:5)
plot(x = rep(1,length(Hardness)), y = Hardness,
     col = getColoursHardness(Hardness), pch = 19,cex = 3)

}
\seealso{
\link{getColoursDensity}, \link{getColoursGrainSize}, \link{getColoursGrainType}, \link{getColoursLWC}, \link{getColoursSnowTemp}
}
\author{
phaegeli
}
