% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deriveDatetag.R
\name{deriveBDate}
\alias{deriveBDate}
\alias{deriveBDate.snowprofileSet}
\alias{deriveBDate.snowprofile}
\alias{deriveBDate.snowprofileLayers}
\title{Derive burial dates from deposition dates in simulated profiles}
\usage{
deriveBDate(x, adjust_bdates = TRUE, ...)

\method{deriveBDate}{snowprofileSet}(x, adjust_bdates = TRUE, ...)

\method{deriveBDate}{snowprofile}(x, adjust_bdates = TRUE, checkMonotonicity = FALSE, ...)

\method{deriveBDate}{snowprofileLayers}(x, adjust_bdates = TRUE, checkMonotonicity = TRUE, ...)
}
\arguments{
\item{x}{a \link{snowprofileSet}, \link{snowprofile} or \link{snowprofileLayers} object}

\item{adjust_bdates}{boolean switch to compute bdates similar to human interpretation.}

\item{...}{passed on to subsequent methods}

\item{checkMonotonicity}{check ascending order of layers. This acts as a check for whether multiple layers objects are stacked, which is not allowed.}
}
\value{
The input object will be returned with the column \code{bdate} added to the profile layers
}
\description{
This routine derives burial dates (\code{bdate}) from deposition dates (\code{ddate}).
Optionally, burial dates can be adjusted to align more closely with human
interpretation (see Details in \link{guessDatetagsSimple}).
}
\section{Methods (by class)}{
\itemize{
\item \code{deriveBDate(snowprofileSet)}: for \link{snowprofileSet}s

\item \code{deriveBDate(snowprofile)}: for \link{snowprofile}s

\item \code{deriveBDate(snowprofileLayers)}: for \link{snowprofileLayers}

}}
\author{
fherla
}
