// Generated by rstantools.  Do not edit by hand.

/*
    rstanarm is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rstanarm is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rstanarm.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_polr_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 259> locations_array__ =
  {" (found before start of program)",
  " (in 'polr', line 232, column 2 to column 16)",
  " (in 'polr', line 235, column 2 to column 44)",
  " (in 'polr', line 236, column 2 to column 43)",
  " (in 'polr', line 237, column 2 to column 39)",
  " (in 'polr', line 240, column 2 to column 17)",
  " (in 'polr', line 241, column 2 to column 26)",
  " (in 'polr', line 294, column 2 to column 64)",
  " (in 'polr', line 295, column 2 to column 41)",
  " (in 'polr', line 296, column 2 to column 21)",
  " (in 'polr', line 243, column 4 to column 17)",
  " (in 'polr', line 248, column 6 to column 41)",
  " (in 'polr', line 249, column 6 to column 40)",
  " (in 'polr', line 247, column 11 to line 250, column 5)",
  " (in 'polr', line 245, column 6 to column 33)",
  " (in 'polr', line 246, column 6 to column 50)",
  " (in 'polr', line 244, column 15 to line 247, column 5)",
  " (in 'polr', line 244, column 4 to line 250, column 5)",
  " (in 'polr', line 251, column 4 to column 50)",
  " (in 'polr', line 242, column 2 to line 252, column 3)",
  " (in 'polr', line 301, column 4 to column 21)",
  " (in 'polr', line 299, column 4 to column 47)",
  " (in 'polr', line 298, column 2 to line 301, column 21)",
  " (in 'polr', line 303, column 4 to column 17)",
  " (in 'polr', line 302, column 2 to line 303, column 17)",
  " (in 'polr', line 306, column 9 to column 10)",
  " (in 'polr', line 306, column 2 to column 16)",
  " (in 'polr', line 311, column 7 to column 32)",
  " (in 'polr', line 309, column 9 to column 66)",
  " (in 'polr', line 308, column 17 to column 35)",
  " (in 'polr', line 308, column 4 to line 309, column 66)",
  " (in 'polr', line 307, column 13 to line 310, column 3)",
  " (in 'polr', line 307, column 2 to line 311, column 32)",
  " (in 'polr', line 312, column 23 to column 38)",
  " (in 'polr', line 312, column 2 to column 38)",
  " (in 'polr', line 313, column 16 to column 39)",
  " (in 'polr', line 313, column 2 to column 39)",
  " (in 'polr', line 315, column 6 to column 18)",
  " (in 'polr', line 316, column 13 to column 14)",
  " (in 'polr', line 316, column 6 to column 22)",
  " (in 'polr', line 317, column 6 to column 20)",
  " (in 'polr', line 318, column 6 to column 57)",
  " (in 'polr', line 319, column 6 to column 23)",
  " (in 'polr', line 323, column 8 to column 25)",
  " (in 'polr', line 321, column 8 to column 36)",
  " (in 'polr', line 320, column 6 to line 323, column 25)",
  " (in 'polr', line 325, column 8 to column 61)",
  " (in 'polr', line 326, column 8 to column 38)",
  " (in 'polr', line 327, column 8 to column 27)",
  " (in 'polr', line 324, column 29 to line 328, column 7)",
  " (in 'polr', line 324, column 6 to line 328, column 7)",
  " (in 'polr', line 332, column 8 to column 43)",
  " (in 'polr', line 330, column 8 to column 32)",
  " (in 'polr', line 329, column 6 to line 332, column 43)",
  " (in 'polr', line 338, column 8 to column 41)",
  " (in 'polr', line 339, column 8 to column 31)",
  " (in 'polr', line 337, column 13 to line 340, column 7)",
  " (in 'polr', line 336, column 8 to column 47)",
  " (in 'polr', line 335, column 25 to line 337, column 7)",
  " (in 'polr', line 335, column 13 to line 340, column 7)",
  " (in 'polr', line 333, column 42 to line 335, column 7)",
  " (in 'polr', line 333, column 6 to line 340, column 7)",
  " (in 'polr', line 342, column 8 to column 19)",
  " (in 'polr', line 350, column 10 to line 351, column 47)",
  " (in 'polr', line 347, column 10 to line 348, column 50)",
  " (in 'polr', line 346, column 13 to line 351, column 47)",
  " (in 'polr', line 344, column 10 to line 345, column 39)",
  " (in 'polr', line 343, column 8 to line 351, column 47)",
  " (in 'polr', line 352, column 8 to column 38)",
  " (in 'polr', line 341, column 24 to line 353, column 7)",
  " (in 'polr', line 341, column 6 to line 353, column 7)",
  " (in 'polr', line 314, column 21 to line 354, column 5)",
  " (in 'polr', line 314, column 4 to line 354, column 5)",
  " (in 'polr', line 355, column 4 to column 26)",
  " (in 'polr', line 304, column 2 to line 356, column 3)",
  " (in 'polr', line 257, column 9 to column 10)",
  " (in 'polr', line 257, column 2 to column 16)",
  " (in 'polr', line 262, column 7 to column 32)",
  " (in 'polr', line 260, column 9 to column 66)",
  " (in 'polr', line 259, column 17 to column 35)",
  " (in 'polr', line 259, column 4 to line 260, column 66)",
  " (in 'polr', line 258, column 13 to line 261, column 3)",
  " (in 'polr', line 258, column 2 to line 262, column 32)",
  " (in 'polr', line 263, column 23 to column 38)",
  " (in 'polr', line 263, column 2 to column 38)",
  " (in 'polr', line 264, column 16 to column 39)",
  " (in 'polr', line 264, column 2 to column 39)",
  " (in 'polr', line 276, column 8 to line 277, column 74)",
  " (in 'polr', line 274, column 8 to column 78)",
  " (in 'polr', line 273, column 6 to line 277, column 74)",
  " (in 'polr', line 271, column 11 to line 278, column 5)",
  " (in 'polr', line 270, column 8 to column 61)",
  " (in 'polr', line 268, column 8 to column 56)",
  " (in 'polr', line 267, column 6 to line 270, column 61)",
  " (in 'polr', line 265, column 26 to line 271, column 5)",
  " (in 'polr', line 265, column 4 to line 278, column 5)",
  " (in 'polr', line 255, column 21 to line 279, column 3)",
  " (in 'polr', line 255, column 2 to line 279, column 3)",
  " (in 'polr', line 281, column 4 to column 48)",
  " (in 'polr', line 280, column 2 to line 281, column 48)",
  " (in 'polr', line 287, column 6 to line 288, column 31)",
  " (in 'polr', line 285, column 6 to column 55)",
  " (in 'polr', line 284, column 4 to line 288, column 31)",
  " (in 'polr', line 283, column 23 to line 289, column 3)",
  " (in 'polr', line 283, column 2 to line 289, column 3)",
  " (in 'polr', line 291, column 4 to column 46)",
  " (in 'polr', line 290, column 2 to line 291, column 46)",
  " (in 'polr', line 162, column 2 to column 17)",
  " (in 'polr', line 163, column 2 to column 17)",
  " (in 'polr', line 166, column 9 to column 10)",
  " (in 'polr', line 166, column 2 to column 17)",
  " (in 'polr', line 167, column 2 to column 31)",
  " (in 'polr', line 168, column 8 to column 15)",
  " (in 'polr', line 168, column 24 to column 25)",
  " (in 'polr', line 168, column 26 to column 27)",
  " (in 'polr', line 168, column 2 to column 31)",
  " (in 'polr', line 171, column 2 to column 21)",
  " (in 'polr', line 172, column 9 to column 14)",
  " (in 'polr', line 172, column 2 to column 20)",
  " (in 'polr', line 173, column 8 to column 13)",
  " (in 'polr', line 173, column 2 to column 43)",
  " (in 'polr', line 175, column 8 to column 27)",
  " (in 'polr', line 175, column 2 to column 69)",
  " (in 'polr', line 178, column 2 to column 24)",
  " (in 'polr', line 179, column 9 to column 10)",
  " (in 'polr', line 179, column 11 to column 19)",
  " (in 'polr', line 179, column 2 to column 23)",
  " (in 'polr', line 180, column 8 to column 16)",
  " (in 'polr', line 180, column 2 to column 42)",
  " (in 'polr', line 181, column 2 to column 17)",
  " (in 'polr', line 182, column 8 to column 9)",
  " (in 'polr', line 182, column 2 to column 35)",
  " (in 'polr', line 186, column 2 to column 32)",
  " (in 'polr', line 187, column 2 to column 40)",
  " (in 'polr', line 190, column 2 to column 37)",
  " (in 'polr', line 193, column 2 to column 20)",
  " (in 'polr', line 197, column 2 to column 34)",
  " (in 'polr', line 198, column 2 to column 48)",
  " (in 'polr', line 201, column 2 to column 42)",
  " (in 'polr', line 204, column 2 to column 45)",
  " (in 'polr', line 208, column 2 to column 35)",
  " (in 'polr', line 209, column 9 to column 28)",
  " (in 'polr', line 209, column 2 to column 38)",
  " (in 'polr', line 212, column 2 to column 34)",
  " (in 'polr', line 213, column 9 to column 27)",
  " (in 'polr', line 213, column 2 to column 37)",
  " (in 'polr', line 215, column 2 to column 31)",
  " (in 'polr', line 216, column 18 to column 19)",
  " (in 'polr', line 216, column 2 to column 34)",
  " (in 'polr', line 217, column 2 to column 34)",
  " (in 'polr', line 218, column 2 to column 22)",
  " (in 'polr', line 219, column 2 to column 21)",
  " (in 'polr', line 220, column 2 to column 37)",
  " (in 'polr', line 223, column 2 to column 33)",
  " (in 'polr', line 224, column 2 to column 41)",
  " (in 'polr', line 225, column 2 to column 40)",
  " (in 'polr', line 226, column 2 to column 24)",
  " (in 'polr', line 229, column 6 to column 22)",
  " (in 'polr', line 228, column 4 to line 229, column 22)",
  " (in 'polr', line 227, column 2 to line 229, column 22)",
  " (in 'polr', line 232, column 10 to column 11)",
  " (in 'polr', line 235, column 8 to column 13)",
  " (in 'polr', line 235, column 27 to column 40)",
  " (in 'polr', line 237, column 8 to column 17)",
  " (in 'polr', line 240, column 9 to column 10)",
  " (in 'polr', line 241, column 9 to column 14)",
  " (in 'polr', line 294, column 9 to column 22)",
  " (in 'polr', line 295, column 9 to column 29)",
  " (in 'polr', line 296, column 9 to column 14)",
  " (in 'polr', line 43, column 6 to column 29)",
  " (in 'polr', line 41, column 6 to column 40)",
  " (in 'polr', line 40, column 9 to line 43, column 29)",
  " (in 'polr', line 39, column 6 to column 28)",
  " (in 'polr', line 38, column 9 to line 43, column 29)",
  " (in 'polr', line 37, column 6 to column 40)",
  " (in 'polr', line 36, column 9 to line 43, column 29)",
  " (in 'polr', line 35, column 6 to column 38)",
  " (in 'polr', line 34, column 9 to line 43, column 29)",
  " (in 'polr', line 33, column 6 to column 35)",
  " (in 'polr', line 32, column 4 to line 43, column 29)",
  " (in 'polr', line 44, column 4 to column 13)",
  " (in 'polr', line 29, column 34 to line 45, column 3)",
  " (in 'polr', line 57, column 4 to column 22)",
  " (in 'polr', line 58, column 4 to column 32)",
  " (in 'polr', line 59, column 11 to column 12)",
  " (in 'polr', line 59, column 4 to column 17)",
  " (in 'polr', line 61, column 6 to column 29)",
  " (in 'polr', line 60, column 4 to line 61, column 29)",
  " (in 'polr', line 79, column 10 to column 74)",
  " (in 'polr', line 77, column 10 to column 72)",
  " (in 'polr', line 76, column 13 to line 79, column 74)",
  " (in 'polr', line 75, column 10 to column 64)",
  " (in 'polr', line 74, column 8 to line 79, column 74)",
  " (in 'polr', line 73, column 23 to line 80, column 7)",
  " (in 'polr', line 73, column 6 to line 80, column 7)",
  " (in 'polr', line 69, column 10 to line 70, column 65)",
  " (in 'polr', line 67, column 10 to column 64)",
  " (in 'polr', line 66, column 13 to line 70, column 65)",
  " (in 'polr', line 65, column 10 to column 56)",
  " (in 'polr', line 64, column 8 to line 70, column 65)",
  " (in 'polr', line 63, column 23 to line 71, column 7)",
  " (in 'polr', line 63, column 6 to line 71, column 7)",
  " (in 'polr', line 62, column 4 to line 80, column 7)",
  " (in 'polr', line 81, column 4 to column 19)",
  " (in 'polr', line 56, column 29 to line 82, column 3)",
  " (in 'polr', line 92, column 4 to column 36)",
  " (in 'polr', line 93, column 11 to column 12)",
  " (in 'polr', line 93, column 4 to column 24)",
  " (in 'polr', line 94, column 4 to column 25)",
  " (in 'polr', line 123, column 6 to column 29)",
  " (in 'polr', line 119, column 8 to column 40)",
  " (in 'polr', line 120, column 8 to column 55)",
  " (in 'polr', line 118, column 23 to line 121, column 7)",
  " (in 'polr', line 118, column 6 to line 121, column 7)",
  " (in 'polr', line 117, column 9 to line 123, column 29)",
  " (in 'polr', line 114, column 8 to column 40)",
  " (in 'polr', line 115, column 8 to column 48)",
  " (in 'polr', line 113, column 23 to line 116, column 7)",
  " (in 'polr', line 113, column 6 to line 116, column 7)",
  " (in 'polr', line 112, column 9 to line 123, column 29)",
  " (in 'polr', line 109, column 8 to column 40)",
  " (in 'polr', line 110, column 8 to column 47)",
  " (in 'polr', line 108, column 23 to line 111, column 7)",
  " (in 'polr', line 108, column 6 to line 111, column 7)",
  " (in 'polr', line 107, column 9 to line 123, column 29)",
  " (in 'polr', line 104, column 8 to column 40)",
  " (in 'polr', line 105, column 8 to column 44)",
  " (in 'polr', line 103, column 23 to line 106, column 7)",
  " (in 'polr', line 103, column 6 to line 106, column 7)",
  " (in 'polr', line 102, column 9 to line 123, column 29)",
  " (in 'polr', line 99, column 8 to column 40)",
  " (in 'polr', line 100, column 8 to column 42)",
  " (in 'polr', line 98, column 23 to line 101, column 7)",
  " (in 'polr', line 98, column 6 to line 101, column 7)",
  " (in 'polr', line 97, column 4 to line 123, column 29)",
  " (in 'polr', line 124, column 4 to column 29)",
  " (in 'polr', line 91, column 68 to line 125, column 3)",
  " (in 'polr', line 136, column 4 to column 17)",
  " (in 'polr', line 137, column 4 to column 32)",
  " (in 'polr', line 139, column 6 to column 43)",
  " (in 'polr', line 138, column 4 to line 139, column 43)",
  " (in 'polr', line 154, column 6 to column 29)",
  " (in 'polr', line 152, column 45 to column 72)",
  " (in 'polr', line 152, column 6 to column 72)",
  " (in 'polr', line 151, column 9 to line 154, column 29)",
  " (in 'polr', line 149, column 45 to line 150, column 72)",
  " (in 'polr', line 149, column 6 to line 150, column 72)",
  " (in 'polr', line 148, column 9 to line 154, column 29)",
  " (in 'polr', line 147, column 45 to column 72)",
  " (in 'polr', line 147, column 6 to column 72)",
  " (in 'polr', line 146, column 9 to line 154, column 29)",
  " (in 'polr', line 145, column 45 to column 72)",
  " (in 'polr', line 145, column 6 to column 72)",
  " (in 'polr', line 144, column 9 to line 154, column 29)",
  " (in 'polr', line 143, column 45 to column 74)",
  " (in 'polr', line 143, column 6 to column 74)",
  " (in 'polr', line 142, column 4 to line 154, column 29)",
  " (in 'polr', line 155, column 4 to column 17)",
  " (in 'polr', line 135, column 63 to line 156, column 3)"};
template <typename T0__,
          stan::require_all_t<stan::is_stan_scalar<T0__>>* = nullptr>
stan::promote_args_t<T0__>
CDF_polr(const T0__& x, const int& link, std::ostream* pstream__);
template <typename T1__, typename T2__, typename T4__,
          stan::require_all_t<stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>,
                              stan::is_stan_scalar<T4__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T1__>,
                stan::base_type_t<T2__>, T4__>,-1,1>
pw_polr(const std::vector<int>& y, const T1__& eta_arg__, const T2__&
        cutpoints_arg__, const int& link, const T4__& alpha, std::ostream*
        pstream__);
template <typename T0__, typename T1__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T1__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>, T1__>,-1,1>
make_cutpoints(const T0__& probabilities_arg__, const T1__& scale, const int&
               link, std::ostream* pstream__);
template <typename T0__, typename T1__, typename T2__, typename RNG,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>>* = nullptr>
stan::promote_args_t<T0__, T1__, T2__>
draw_ystar_rng(const T0__& low, const T1__& high, const T2__& eta, const int&
               link, RNG& base_rng__, std::ostream* pstream__);
template <typename T0__, stan::require_all_t<stan::is_stan_scalar<T0__>>*>
stan::promote_args_t<T0__>
CDF_polr(const T0__& x, const int& link, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__>;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 179;
    if (stan::math::logical_eq(link, 1)) {
      current_statement__ = 178;
      return stan::math::exp(stan::math::log_inv_logit(x));
    } else {
      current_statement__ = 177;
      if (stan::math::logical_eq(link, 2)) {
        current_statement__ = 176;
        return stan::math::exp(stan::math::std_normal_lcdf(x));
      } else {
        current_statement__ = 175;
        if (stan::math::logical_eq(link, 3)) {
          current_statement__ = 174;
          return stan::math::exp(stan::math::gumbel_lcdf(x, 0, 1));
        } else {
          current_statement__ = 173;
          if (stan::math::logical_eq(link, 4)) {
            current_statement__ = 172;
            return stan::math::inv_cloglog(x);
          } else {
            current_statement__ = 171;
            if (stan::math::logical_eq(link, 5)) {
              current_statement__ = 170;
              return stan::math::exp(stan::math::cauchy_lcdf(x, 0, 1));
            } else {
              current_statement__ = 169;
              std::stringstream errmsg_stream__;
              stan::math::stan_print(&errmsg_stream__, "Invalid link");
              throw std::domain_error(errmsg_stream__.str());
            }
          }
        }
      }
    }
    current_statement__ = 180;
    return x;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T1__, typename T2__, typename T4__,
          stan::require_all_t<stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>,
                              stan::is_stan_scalar<T4__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T1__>,
                stan::base_type_t<T2__>, T4__>,-1,1>
pw_polr(const std::vector<int>& y, const T1__& eta_arg__, const T2__&
        cutpoints_arg__, const int& link, const T4__& alpha, std::ostream*
        pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T1__>,
                             stan::base_type_t<T2__>, T4__>;
  int current_statement__ = 0;
  const auto& eta = stan::math::to_ref(eta_arg__);
  const auto& cutpoints = stan::math::to_ref(cutpoints_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int N = std::numeric_limits<int>::min();
    current_statement__ = 182;
    N = stan::math::rows(eta);
    int J = std::numeric_limits<int>::min();
    current_statement__ = 183;
    J = (stan::math::rows(cutpoints) + 1);
    current_statement__ = 184;
    stan::math::validate_non_negative_index("ll", "N", N);
    Eigen::Matrix<local_scalar_t__,-1,1> ll =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
    current_statement__ = 187;
    if ((stan::math::primitive_value(stan::math::logical_lt(link, 1)) ||
        stan::math::primitive_value(stan::math::logical_gt(link, 5)))) {
      current_statement__ = 186;
      std::stringstream errmsg_stream__;
      stan::math::stan_print(&errmsg_stream__, "Invalid link");
      throw std::domain_error(errmsg_stream__.str());
    }
    current_statement__ = 202;
    if (stan::math::logical_eq(alpha, 1)) {
      current_statement__ = 201;
      for (int n = 1; n <= N; ++n) {
        current_statement__ = 199;
        if (stan::math::logical_eq(
              stan::model::rvalue(y, "y", stan::model::index_uni(n)), 1)) {
          current_statement__ = 198;
          stan::model::assign(ll,
            CDF_polr(
              (stan::model::rvalue(cutpoints, "cutpoints",
                 stan::model::index_uni(1)) -
              stan::model::rvalue(eta, "eta", stan::model::index_uni(n))),
              link, pstream__), "assigning variable ll",
            stan::model::index_uni(n));
        } else {
          current_statement__ = 197;
          if (stan::math::logical_eq(
                stan::model::rvalue(y, "y", stan::model::index_uni(n)), J)) {
            current_statement__ = 196;
            stan::model::assign(ll, (1 -
              CDF_polr(
                (stan::model::rvalue(cutpoints, "cutpoints",
                   stan::model::index_uni((J - 1))) -
                stan::model::rvalue(eta, "eta", stan::model::index_uni(n))),
                link, pstream__)), "assigning variable ll",
              stan::model::index_uni(n));
          } else {
            current_statement__ = 195;
            stan::model::assign(ll,
              (CDF_polr(
                 (stan::model::rvalue(cutpoints, "cutpoints",
                    stan::model::index_uni(
                      stan::model::rvalue(y, "y", stan::model::index_uni(n))))
                 -
                 stan::model::rvalue(eta, "eta", stan::model::index_uni(n))),
                 link, pstream__) -
              CDF_polr(
                (stan::model::rvalue(cutpoints, "cutpoints",
                   stan::model::index_uni(
                     (stan::model::rvalue(y, "y", stan::model::index_uni(n))
                     - 1))) -
                stan::model::rvalue(eta, "eta", stan::model::index_uni(n))),
                link, pstream__)), "assigning variable ll",
              stan::model::index_uni(n));
          }
        }
      }
    } else {
      current_statement__ = 194;
      for (int n = 1; n <= N; ++n) {
        current_statement__ = 192;
        if (stan::math::logical_eq(
              stan::model::rvalue(y, "y", stan::model::index_uni(n)), 1)) {
          current_statement__ = 191;
          stan::model::assign(ll,
            stan::math::pow(
              CDF_polr(
                (stan::model::rvalue(cutpoints, "cutpoints",
                   stan::model::index_uni(1)) -
                stan::model::rvalue(eta, "eta", stan::model::index_uni(n))),
                link, pstream__), alpha), "assigning variable ll",
            stan::model::index_uni(n));
        } else {
          current_statement__ = 190;
          if (stan::math::logical_eq(
                stan::model::rvalue(y, "y", stan::model::index_uni(n)), J)) {
            current_statement__ = 189;
            stan::model::assign(ll, (1 -
              stan::math::pow(
                CDF_polr(
                  (stan::model::rvalue(cutpoints, "cutpoints",
                     stan::model::index_uni((J - 1))) -
                  stan::model::rvalue(eta, "eta", stan::model::index_uni(n))),
                  link, pstream__), alpha)), "assigning variable ll",
              stan::model::index_uni(n));
          } else {
            current_statement__ = 188;
            std::stringstream errmsg_stream__;
            stan::math::stan_print(&errmsg_stream__,
              "alpha not allowed with more than 2 outcome categories");
            throw std::domain_error(errmsg_stream__.str());
          }
        }
      }
    }
    current_statement__ = 203;
    return stan::math::log(ll);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T1__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T1__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>, T1__>,-1,1>
make_cutpoints(const T0__& probabilities_arg__, const T1__& scale, const int&
               link, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             T1__>;
  int current_statement__ = 0;
  const auto& probabilities = stan::math::to_ref(probabilities_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int C = std::numeric_limits<int>::min();
    current_statement__ = 205;
    C = (stan::math::rows(probabilities) - 1);
    current_statement__ = 206;
    stan::math::validate_non_negative_index("cutpoints", "C", C);
    Eigen::Matrix<local_scalar_t__,-1,1> cutpoints =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(C, DUMMY_VAR__);
    local_scalar_t__ running_sum = DUMMY_VAR__;
    current_statement__ = 208;
    running_sum = 0;
    current_statement__ = 234;
    if (stan::math::logical_eq(link, 1)) {
      current_statement__ = 233;
      for (int c = 1; c <= C; ++c) {
        current_statement__ = 230;
        running_sum = (running_sum +
          stan::model::rvalue(probabilities, "probabilities",
            stan::model::index_uni(c)));
        current_statement__ = 231;
        stan::model::assign(cutpoints, stan::math::logit(running_sum),
          "assigning variable cutpoints", stan::model::index_uni(c));
      }
    } else {
      current_statement__ = 229;
      if (stan::math::logical_eq(link, 2)) {
        current_statement__ = 228;
        for (int c = 1; c <= C; ++c) {
          current_statement__ = 225;
          running_sum = (running_sum +
            stan::model::rvalue(probabilities, "probabilities",
              stan::model::index_uni(c)));
          current_statement__ = 226;
          stan::model::assign(cutpoints, stan::math::inv_Phi(running_sum),
            "assigning variable cutpoints", stan::model::index_uni(c));
        }
      } else {
        current_statement__ = 224;
        if (stan::math::logical_eq(link, 3)) {
          current_statement__ = 223;
          for (int c = 1; c <= C; ++c) {
            current_statement__ = 220;
            running_sum = (running_sum +
              stan::model::rvalue(probabilities, "probabilities",
                stan::model::index_uni(c)));
            current_statement__ = 221;
            stan::model::assign(cutpoints,
              -stan::math::log(-stan::math::log(running_sum)),
              "assigning variable cutpoints", stan::model::index_uni(c));
          }
        } else {
          current_statement__ = 219;
          if (stan::math::logical_eq(link, 4)) {
            current_statement__ = 218;
            for (int c = 1; c <= C; ++c) {
              current_statement__ = 215;
              running_sum = (running_sum +
                stan::model::rvalue(probabilities, "probabilities",
                  stan::model::index_uni(c)));
              current_statement__ = 216;
              stan::model::assign(cutpoints,
                stan::math::log(-stan::math::log1m(running_sum)),
                "assigning variable cutpoints", stan::model::index_uni(c));
            }
          } else {
            current_statement__ = 214;
            if (stan::math::logical_eq(link, 5)) {
              current_statement__ = 213;
              for (int c = 1; c <= C; ++c) {
                current_statement__ = 210;
                running_sum = (running_sum +
                  stan::model::rvalue(probabilities, "probabilities",
                    stan::model::index_uni(c)));
                current_statement__ = 211;
                stan::model::assign(cutpoints,
                  stan::math::tan((stan::math::pi() * (running_sum - 0.5))),
                  "assigning variable cutpoints", stan::model::index_uni(c));
              }
            } else {
              current_statement__ = 209;
              std::stringstream errmsg_stream__;
              stan::math::stan_print(&errmsg_stream__, "invalid link");
              throw std::domain_error(errmsg_stream__.str());
            }
          }
        }
      }
    }
    current_statement__ = 235;
    return stan::math::multiply(scale, cutpoints);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T1__, typename T2__, typename RNG,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>>*>
stan::promote_args_t<T0__, T1__, T2__>
draw_ystar_rng(const T0__& low, const T1__& high, const T2__& eta, const int&
               link, RNG& base_rng__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__>;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int iter = std::numeric_limits<int>::min();
    current_statement__ = 237;
    iter = 0;
    local_scalar_t__ ystar = DUMMY_VAR__;
    current_statement__ = 238;
    ystar = stan::math::not_a_number();
    current_statement__ = 240;
    if (stan::math::logical_gte(low, high)) {
      current_statement__ = 239;
      std::stringstream errmsg_stream__;
      stan::math::stan_print(&errmsg_stream__, "low must be less than high");
      throw std::domain_error(errmsg_stream__.str());
    }
    current_statement__ = 256;
    if (stan::math::logical_eq(link, 1)) {
      current_statement__ = 255;
      while (stan::math::logical_negation(
               (stan::math::primitive_value(
                  stan::math::logical_gt(ystar, low)) &&
               stan::math::primitive_value(
                 stan::math::logical_lt(ystar, high))))) {
        current_statement__ = 254;
        ystar = stan::math::logistic_rng(eta, 1, base_rng__);
      }
    } else {
      current_statement__ = 253;
      if (stan::math::logical_eq(link, 2)) {
        current_statement__ = 252;
        while (stan::math::logical_negation(
                 (stan::math::primitive_value(
                    stan::math::logical_gt(ystar, low)) &&
                 stan::math::primitive_value(
                   stan::math::logical_lt(ystar, high))))) {
          current_statement__ = 251;
          ystar = stan::math::normal_rng(eta, 1, base_rng__);
        }
      } else {
        current_statement__ = 250;
        if (stan::math::logical_eq(link, 3)) {
          current_statement__ = 249;
          while (stan::math::logical_negation(
                   (stan::math::primitive_value(
                      stan::math::logical_gt(ystar, low)) &&
                   stan::math::primitive_value(
                     stan::math::logical_lt(ystar, high))))) {
            current_statement__ = 248;
            ystar = stan::math::gumbel_rng(eta, 1, base_rng__);
          }
        } else {
          current_statement__ = 247;
          if (stan::math::logical_eq(link, 4)) {
            current_statement__ = 246;
            while (stan::math::logical_negation(
                     (stan::math::primitive_value(
                        stan::math::logical_gt(ystar, low)) &&
                     stan::math::primitive_value(
                       stan::math::logical_lt(ystar, high))))) {
              current_statement__ = 245;
              ystar = stan::math::log(
                        -stan::math::log1m(
                           stan::math::uniform_rng(0, 1, base_rng__)));
            }
          } else {
            current_statement__ = 244;
            if (stan::math::logical_eq(link, 5)) {
              current_statement__ = 243;
              while (stan::math::logical_negation(
                       (stan::math::primitive_value(
                          stan::math::logical_gt(ystar, low)) &&
                       stan::math::primitive_value(
                         stan::math::logical_lt(ystar, high))))) {
                current_statement__ = 242;
                ystar = stan::math::cauchy_rng(eta, 1, base_rng__);
              }
            } else {
              current_statement__ = 241;
              std::stringstream errmsg_stream__;
              stan::math::stan_print(&errmsg_stream__, "invalid link");
              throw std::domain_error(errmsg_stream__.str());
            }
          }
        }
      }
    }
    current_statement__ = 257;
    return ystar;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_polr final : public model_base_crtp<model_polr> {
private:
  int N;
  int K;
  Eigen::Matrix<double,-1,1> xbar_data__;
  int dense_X;
  std::vector<Eigen::Matrix<double,-1,-1>> X;
  int nnz_X;
  Eigen::Matrix<double,-1,1> w_X_data__;
  std::vector<int> v_X;
  std::vector<int> u_X;
  int K_smooth;
  Eigen::Matrix<double,-1,-1> S_data__;
  std::vector<int> smooth_map;
  int J;
  std::vector<int> y;
  int prior_PD;
  int compute_mean_PPD;
  int has_intercept;
  int link;
  int prior_dist;
  int prior_dist_for_intercept;
  int prior_dist_for_aux;
  int prior_dist_for_smooth;
  int has_weights;
  Eigen::Matrix<double,-1,1> weights_data__;
  int has_offset;
  Eigen::Matrix<double,-1,1> offset__data__;
  double regularization;
  Eigen::Matrix<double,-1,1> prior_counts_data__;
  int is_skewed;
  double shape;
  double rate;
  int do_residuals;
  double half_K;
  double sqrt_Nm1;
  int is_constant;
  Eigen::Matrix<double,-1,1> beta_smooth_data__;
  int u_1dim__;
  int u_2dim__;
  int cutpoints_1dim__;
  int mean_PPD_1dim__;
  int residuals_1dim__;
  int zeta_1dim__;
  Eigen::Map<Eigen::Matrix<double,-1,1>> xbar{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> w_X{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> S{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> weights{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> offset_{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> prior_counts{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> beta_smooth{nullptr, 0};
public:
  ~model_polr() {}
  model_polr(stan::io::var_context& context__, unsigned int
             random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_polr_namespace::model_polr";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 107;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 107;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 107;
      stan::math::check_greater_or_equal(function__, "N", N, 0);
      current_statement__ = 108;
      context__.validate_dims("data initialization", "K", "int",
        std::vector<size_t>{});
      K = std::numeric_limits<int>::min();
      current_statement__ = 108;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 108;
      stan::math::check_greater_or_equal(function__, "K", K, 0);
      current_statement__ = 109;
      stan::math::validate_non_negative_index("xbar", "K", K);
      current_statement__ = 110;
      context__.validate_dims("data initialization", "xbar", "double",
        std::vector<size_t>{static_cast<size_t>(K)});
      xbar_data__ = Eigen::Matrix<double,-1,1>::Constant(K,
                      std::numeric_limits<double>::quiet_NaN());
      new (&xbar) Eigen::Map<Eigen::Matrix<double,-1,1>>(xbar_data__.data(),
        K);
      {
        std::vector<local_scalar_t__> xbar_flat__;
        current_statement__ = 110;
        xbar_flat__ = context__.vals_r("xbar");
        current_statement__ = 110;
        pos__ = 1;
        current_statement__ = 110;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 110;
          stan::model::assign(xbar, xbar_flat__[(pos__ - 1)],
            "assigning variable xbar", stan::model::index_uni(sym1__));
          current_statement__ = 110;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 111;
      context__.validate_dims("data initialization", "dense_X", "int",
        std::vector<size_t>{});
      dense_X = std::numeric_limits<int>::min();
      current_statement__ = 111;
      dense_X = context__.vals_i("dense_X")[(1 - 1)];
      current_statement__ = 111;
      stan::math::check_greater_or_equal(function__, "dense_X", dense_X, 0);
      current_statement__ = 111;
      stan::math::check_less_or_equal(function__, "dense_X", dense_X, 1);
      current_statement__ = 112;
      stan::math::validate_non_negative_index("X", "dense_X", dense_X);
      current_statement__ = 113;
      stan::math::validate_non_negative_index("X", "N", N);
      current_statement__ = 114;
      stan::math::validate_non_negative_index("X", "K", K);
      current_statement__ = 115;
      context__.validate_dims("data initialization", "X", "double",
        std::vector<size_t>{static_cast<size_t>(dense_X),
          static_cast<size_t>(N), static_cast<size_t>(K)});
      X = std::vector<Eigen::Matrix<double,-1,-1>>(dense_X,
            Eigen::Matrix<double,-1,-1>::Constant(N, K,
              std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 115;
        X_flat__ = context__.vals_r("X");
        current_statement__ = 115;
        pos__ = 1;
        current_statement__ = 115;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 115;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 115;
            for (int sym3__ = 1; sym3__ <= dense_X; ++sym3__) {
              current_statement__ = 115;
              stan::model::assign(X, X_flat__[(pos__ - 1)],
                "assigning variable X", stan::model::index_uni(sym3__),
                stan::model::index_uni(sym2__),
                stan::model::index_uni(sym1__));
              current_statement__ = 115;
              pos__ = (pos__ + 1);
            }
          }
        }
      }
      current_statement__ = 116;
      context__.validate_dims("data initialization", "nnz_X", "int",
        std::vector<size_t>{});
      nnz_X = std::numeric_limits<int>::min();
      current_statement__ = 116;
      nnz_X = context__.vals_i("nnz_X")[(1 - 1)];
      current_statement__ = 116;
      stan::math::check_greater_or_equal(function__, "nnz_X", nnz_X, 0);
      current_statement__ = 117;
      stan::math::validate_non_negative_index("w_X", "nnz_X", nnz_X);
      current_statement__ = 118;
      context__.validate_dims("data initialization", "w_X", "double",
        std::vector<size_t>{static_cast<size_t>(nnz_X)});
      w_X_data__ = Eigen::Matrix<double,-1,1>::Constant(nnz_X,
                     std::numeric_limits<double>::quiet_NaN());
      new (&w_X) Eigen::Map<Eigen::Matrix<double,-1,1>>(w_X_data__.data(),
        nnz_X);
      {
        std::vector<local_scalar_t__> w_X_flat__;
        current_statement__ = 118;
        w_X_flat__ = context__.vals_r("w_X");
        current_statement__ = 118;
        pos__ = 1;
        current_statement__ = 118;
        for (int sym1__ = 1; sym1__ <= nnz_X; ++sym1__) {
          current_statement__ = 118;
          stan::model::assign(w_X, w_X_flat__[(pos__ - 1)],
            "assigning variable w_X", stan::model::index_uni(sym1__));
          current_statement__ = 118;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 119;
      stan::math::validate_non_negative_index("v_X", "nnz_X", nnz_X);
      current_statement__ = 120;
      context__.validate_dims("data initialization", "v_X", "int",
        std::vector<size_t>{static_cast<size_t>(nnz_X)});
      v_X = std::vector<int>(nnz_X, std::numeric_limits<int>::min());
      current_statement__ = 120;
      v_X = context__.vals_i("v_X");
      current_statement__ = 120;
      stan::math::check_greater_or_equal(function__, "v_X", v_X, 1);
      current_statement__ = 120;
      stan::math::check_less_or_equal(function__, "v_X", v_X, K);
      current_statement__ = 121;
      stan::math::validate_non_negative_index("u_X", "dense_X ? 0 : N + 1",
        (dense_X ? 0 : (N + 1)));
      current_statement__ = 122;
      context__.validate_dims("data initialization", "u_X", "int",
        std::vector<size_t>{static_cast<size_t>((dense_X ? 0 : (N + 1)))});
      u_X = std::vector<int>((dense_X ? 0 : (N + 1)),
              std::numeric_limits<int>::min());
      current_statement__ = 122;
      u_X = context__.vals_i("u_X");
      current_statement__ = 122;
      stan::math::check_greater_or_equal(function__, "u_X", u_X, 1);
      current_statement__ = 122;
      stan::math::check_less_or_equal(function__, "u_X", u_X,
        (stan::math::rows(w_X) + 1));
      current_statement__ = 123;
      context__.validate_dims("data initialization", "K_smooth", "int",
        std::vector<size_t>{});
      K_smooth = std::numeric_limits<int>::min();
      current_statement__ = 123;
      K_smooth = context__.vals_i("K_smooth")[(1 - 1)];
      current_statement__ = 123;
      stan::math::check_greater_or_equal(function__, "K_smooth", K_smooth, 0);
      current_statement__ = 124;
      stan::math::validate_non_negative_index("S", "N", N);
      current_statement__ = 125;
      stan::math::validate_non_negative_index("S", "K_smooth", K_smooth);
      current_statement__ = 126;
      context__.validate_dims("data initialization", "S", "double",
        std::vector<size_t>{static_cast<size_t>(N),
          static_cast<size_t>(K_smooth)});
      S_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, K_smooth,
                   std::numeric_limits<double>::quiet_NaN());
      new (&S) Eigen::Map<Eigen::Matrix<double,-1,-1>>(S_data__.data(), N,
        K_smooth);
      {
        std::vector<local_scalar_t__> S_flat__;
        current_statement__ = 126;
        S_flat__ = context__.vals_r("S");
        current_statement__ = 126;
        pos__ = 1;
        current_statement__ = 126;
        for (int sym1__ = 1; sym1__ <= K_smooth; ++sym1__) {
          current_statement__ = 126;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 126;
            stan::model::assign(S, S_flat__[(pos__ - 1)],
              "assigning variable S", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 126;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 127;
      stan::math::validate_non_negative_index("smooth_map", "K_smooth",
        K_smooth);
      current_statement__ = 128;
      context__.validate_dims("data initialization", "smooth_map", "int",
        std::vector<size_t>{static_cast<size_t>(K_smooth)});
      smooth_map = std::vector<int>(K_smooth,
                     std::numeric_limits<int>::min());
      current_statement__ = 128;
      smooth_map = context__.vals_i("smooth_map");
      current_statement__ = 128;
      stan::math::check_greater_or_equal(function__, "smooth_map",
        smooth_map, 1);
      current_statement__ = 129;
      context__.validate_dims("data initialization", "J", "int",
        std::vector<size_t>{});
      J = std::numeric_limits<int>::min();
      current_statement__ = 129;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 129;
      stan::math::check_greater_or_equal(function__, "J", J, 2);
      current_statement__ = 130;
      stan::math::validate_non_negative_index("y", "N", N);
      current_statement__ = 131;
      context__.validate_dims("data initialization", "y", "int",
        std::vector<size_t>{static_cast<size_t>(N)});
      y = std::vector<int>(N, std::numeric_limits<int>::min());
      current_statement__ = 131;
      y = context__.vals_i("y");
      current_statement__ = 131;
      stan::math::check_greater_or_equal(function__, "y", y, 1);
      current_statement__ = 131;
      stan::math::check_less_or_equal(function__, "y", y, J);
      current_statement__ = 132;
      context__.validate_dims("data initialization", "prior_PD", "int",
        std::vector<size_t>{});
      prior_PD = std::numeric_limits<int>::min();
      current_statement__ = 132;
      prior_PD = context__.vals_i("prior_PD")[(1 - 1)];
      current_statement__ = 132;
      stan::math::check_greater_or_equal(function__, "prior_PD", prior_PD, 0);
      current_statement__ = 132;
      stan::math::check_less_or_equal(function__, "prior_PD", prior_PD, 1);
      current_statement__ = 133;
      context__.validate_dims("data initialization", "compute_mean_PPD",
        "int", std::vector<size_t>{});
      compute_mean_PPD = std::numeric_limits<int>::min();
      current_statement__ = 133;
      compute_mean_PPD = context__.vals_i("compute_mean_PPD")[(1 - 1)];
      current_statement__ = 133;
      stan::math::check_greater_or_equal(function__, "compute_mean_PPD",
        compute_mean_PPD, 0);
      current_statement__ = 133;
      stan::math::check_less_or_equal(function__, "compute_mean_PPD",
        compute_mean_PPD, 1);
      current_statement__ = 134;
      context__.validate_dims("data initialization", "has_intercept", "int",
        std::vector<size_t>{});
      has_intercept = std::numeric_limits<int>::min();
      current_statement__ = 134;
      has_intercept = context__.vals_i("has_intercept")[(1 - 1)];
      current_statement__ = 134;
      stan::math::check_greater_or_equal(function__, "has_intercept",
        has_intercept, 0);
      current_statement__ = 134;
      stan::math::check_less_or_equal(function__, "has_intercept",
        has_intercept, 1);
      current_statement__ = 135;
      context__.validate_dims("data initialization", "link", "int",
        std::vector<size_t>{});
      link = std::numeric_limits<int>::min();
      current_statement__ = 135;
      link = context__.vals_i("link")[(1 - 1)];
      current_statement__ = 135;
      stan::math::check_greater_or_equal(function__, "link", link, 1);
      current_statement__ = 136;
      context__.validate_dims("data initialization", "prior_dist", "int",
        std::vector<size_t>{});
      prior_dist = std::numeric_limits<int>::min();
      current_statement__ = 136;
      prior_dist = context__.vals_i("prior_dist")[(1 - 1)];
      current_statement__ = 136;
      stan::math::check_greater_or_equal(function__, "prior_dist",
        prior_dist, 0);
      current_statement__ = 136;
      stan::math::check_less_or_equal(function__, "prior_dist", prior_dist, 7);
      current_statement__ = 137;
      context__.validate_dims("data initialization",
        "prior_dist_for_intercept", "int", std::vector<size_t>{});
      prior_dist_for_intercept = std::numeric_limits<int>::min();
      current_statement__ = 137;
      prior_dist_for_intercept = context__.vals_i("prior_dist_for_intercept")[(1
        - 1)];
      current_statement__ = 137;
      stan::math::check_greater_or_equal(function__,
        "prior_dist_for_intercept", prior_dist_for_intercept, 0);
      current_statement__ = 137;
      stan::math::check_less_or_equal(function__, "prior_dist_for_intercept",
        prior_dist_for_intercept, 2);
      current_statement__ = 138;
      context__.validate_dims("data initialization", "prior_dist_for_aux",
        "int", std::vector<size_t>{});
      prior_dist_for_aux = std::numeric_limits<int>::min();
      current_statement__ = 138;
      prior_dist_for_aux = context__.vals_i("prior_dist_for_aux")[(1 - 1)];
      current_statement__ = 138;
      stan::math::check_greater_or_equal(function__, "prior_dist_for_aux",
        prior_dist_for_aux, 0);
      current_statement__ = 138;
      stan::math::check_less_or_equal(function__, "prior_dist_for_aux",
        prior_dist_for_aux, 3);
      current_statement__ = 139;
      context__.validate_dims("data initialization", "prior_dist_for_smooth",
        "int", std::vector<size_t>{});
      prior_dist_for_smooth = std::numeric_limits<int>::min();
      current_statement__ = 139;
      prior_dist_for_smooth = context__.vals_i("prior_dist_for_smooth")[(1 -
        1)];
      current_statement__ = 139;
      stan::math::check_greater_or_equal(function__, "prior_dist_for_smooth",
        prior_dist_for_smooth, 0);
      current_statement__ = 139;
      stan::math::check_less_or_equal(function__, "prior_dist_for_smooth",
        prior_dist_for_smooth, 3);
      current_statement__ = 140;
      context__.validate_dims("data initialization", "has_weights", "int",
        std::vector<size_t>{});
      has_weights = std::numeric_limits<int>::min();
      current_statement__ = 140;
      has_weights = context__.vals_i("has_weights")[(1 - 1)];
      current_statement__ = 140;
      stan::math::check_greater_or_equal(function__, "has_weights",
        has_weights, 0);
      current_statement__ = 140;
      stan::math::check_less_or_equal(function__, "has_weights", has_weights,
        1);
      current_statement__ = 141;
      stan::math::validate_non_negative_index("weights",
        "has_weights ? N : 0", (has_weights ? N : 0));
      current_statement__ = 142;
      context__.validate_dims("data initialization", "weights", "double",
        std::vector<size_t>{static_cast<size_t>((has_weights ? N : 0))});
      weights_data__ = Eigen::Matrix<double,-1,1>::Constant((has_weights ? N : 0),
                         std::numeric_limits<double>::quiet_NaN());
      new (&weights)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(weights_data__.data(),
        (has_weights ? N : 0));
      {
        std::vector<local_scalar_t__> weights_flat__;
        current_statement__ = 142;
        weights_flat__ = context__.vals_r("weights");
        current_statement__ = 142;
        pos__ = 1;
        current_statement__ = 142;
        for (int sym1__ = 1; sym1__ <= (has_weights ? N : 0); ++sym1__) {
          current_statement__ = 142;
          stan::model::assign(weights, weights_flat__[(pos__ - 1)],
            "assigning variable weights", stan::model::index_uni(sym1__));
          current_statement__ = 142;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 143;
      context__.validate_dims("data initialization", "has_offset", "int",
        std::vector<size_t>{});
      has_offset = std::numeric_limits<int>::min();
      current_statement__ = 143;
      has_offset = context__.vals_i("has_offset")[(1 - 1)];
      current_statement__ = 143;
      stan::math::check_greater_or_equal(function__, "has_offset",
        has_offset, 0);
      current_statement__ = 143;
      stan::math::check_less_or_equal(function__, "has_offset", has_offset, 1);
      current_statement__ = 144;
      stan::math::validate_non_negative_index("offset_",
        "has_offset ? N : 0", (has_offset ? N : 0));
      current_statement__ = 145;
      context__.validate_dims("data initialization", "offset_", "double",
        std::vector<size_t>{static_cast<size_t>((has_offset ? N : 0))});
      offset__data__ = Eigen::Matrix<double,-1,1>::Constant((has_offset ? N : 0),
                         std::numeric_limits<double>::quiet_NaN());
      new (&offset_)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(offset__data__.data(),
        (has_offset ? N : 0));
      {
        std::vector<local_scalar_t__> offset__flat__;
        current_statement__ = 145;
        offset__flat__ = context__.vals_r("offset_");
        current_statement__ = 145;
        pos__ = 1;
        current_statement__ = 145;
        for (int sym1__ = 1; sym1__ <= (has_offset ? N : 0); ++sym1__) {
          current_statement__ = 145;
          stan::model::assign(offset_, offset__flat__[(pos__ - 1)],
            "assigning variable offset_", stan::model::index_uni(sym1__));
          current_statement__ = 145;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 146;
      context__.validate_dims("data initialization", "regularization",
        "double", std::vector<size_t>{});
      regularization = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 146;
      regularization = context__.vals_r("regularization")[(1 - 1)];
      current_statement__ = 146;
      stan::math::check_greater_or_equal(function__, "regularization",
        regularization, 0);
      current_statement__ = 147;
      stan::math::validate_non_negative_index("prior_counts", "J", J);
      current_statement__ = 148;
      context__.validate_dims("data initialization", "prior_counts",
        "double", std::vector<size_t>{static_cast<size_t>(J)});
      prior_counts_data__ = Eigen::Matrix<double,-1,1>::Constant(J,
                              std::numeric_limits<double>::quiet_NaN());
      new (&prior_counts)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(prior_counts_data__.data(), J);
      {
        std::vector<local_scalar_t__> prior_counts_flat__;
        current_statement__ = 148;
        prior_counts_flat__ = context__.vals_r("prior_counts");
        current_statement__ = 148;
        pos__ = 1;
        current_statement__ = 148;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 148;
          stan::model::assign(prior_counts, prior_counts_flat__[(pos__ - 1)],
            "assigning variable prior_counts", stan::model::index_uni(sym1__));
          current_statement__ = 148;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 148;
      stan::math::check_greater_or_equal(function__, "prior_counts",
        prior_counts, 0);
      current_statement__ = 149;
      context__.validate_dims("data initialization", "is_skewed", "int",
        std::vector<size_t>{});
      is_skewed = std::numeric_limits<int>::min();
      current_statement__ = 149;
      is_skewed = context__.vals_i("is_skewed")[(1 - 1)];
      current_statement__ = 149;
      stan::math::check_greater_or_equal(function__, "is_skewed", is_skewed,
        0);
      current_statement__ = 149;
      stan::math::check_less_or_equal(function__, "is_skewed", is_skewed, 1);
      current_statement__ = 150;
      context__.validate_dims("data initialization", "shape", "double",
        std::vector<size_t>{});
      shape = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 150;
      shape = context__.vals_r("shape")[(1 - 1)];
      current_statement__ = 150;
      stan::math::check_greater_or_equal(function__, "shape", shape, 0);
      current_statement__ = 151;
      context__.validate_dims("data initialization", "rate", "double",
        std::vector<size_t>{});
      rate = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 151;
      rate = context__.vals_r("rate")[(1 - 1)];
      current_statement__ = 151;
      stan::math::check_greater_or_equal(function__, "rate", rate, 0);
      current_statement__ = 152;
      context__.validate_dims("data initialization", "do_residuals", "int",
        std::vector<size_t>{});
      do_residuals = std::numeric_limits<int>::min();
      current_statement__ = 152;
      do_residuals = context__.vals_i("do_residuals")[(1 - 1)];
      current_statement__ = 152;
      stan::math::check_greater_or_equal(function__, "do_residuals",
        do_residuals, 0);
      current_statement__ = 152;
      stan::math::check_less_or_equal(function__, "do_residuals",
        do_residuals, 1);
      current_statement__ = 153;
      half_K = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 153;
      half_K = (0.5 * K);
      current_statement__ = 154;
      sqrt_Nm1 = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 154;
      sqrt_Nm1 = stan::math::sqrt((N - 1.0));
      current_statement__ = 155;
      is_constant = std::numeric_limits<int>::min();
      current_statement__ = 155;
      is_constant = 1;
      current_statement__ = 156;
      beta_smooth_data__ = Eigen::Matrix<double,-1,1>::Constant(0,
                             std::numeric_limits<double>::quiet_NaN());
      new (&beta_smooth)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(beta_smooth_data__.data(), 0);
      current_statement__ = 159;
      for (int j = 1; j <= J; ++j) {
        current_statement__ = 158;
        if (stan::math::logical_neq(
              stan::model::rvalue(prior_counts, "prior_counts",
                stan::model::index_uni(j)), 1)) {
          current_statement__ = 157;
          is_constant = 0;
        }
      }
      current_statement__ = 153;
      stan::math::check_greater_or_equal(function__, "half_K", half_K, 0);
      current_statement__ = 154;
      stan::math::check_greater_or_equal(function__, "sqrt_Nm1", sqrt_Nm1, 0);
      current_statement__ = 155;
      stan::math::check_greater_or_equal(function__, "is_constant",
        is_constant, 0);
      current_statement__ = 155;
      stan::math::check_less_or_equal(function__, "is_constant", is_constant,
        1);
      current_statement__ = 160;
      stan::math::validate_positive_index("pi", "J", J);
      current_statement__ = 161;
      u_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 161;
      u_1dim__ = stan::math::logical_gt(K, 1);
      current_statement__ = 161;
      stan::math::validate_non_negative_index("u", "K > 1", u_1dim__);
      current_statement__ = 162;
      u_2dim__ = std::numeric_limits<int>::min();
      current_statement__ = 162;
      u_2dim__ = (stan::math::logical_gt(K, 1) ? K : 2);
      current_statement__ = 162;
      stan::math::validate_unit_vector_index("u", "K > 1 ? K : 2", u_2dim__);
      current_statement__ = 163;
      stan::math::validate_non_negative_index("alpha", "is_skewed", is_skewed);
      current_statement__ = 164;
      stan::math::validate_non_negative_index("beta", "K", K);
      current_statement__ = 165;
      cutpoints_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 165;
      cutpoints_1dim__ = (J - 1);
      current_statement__ = 165;
      stan::math::validate_non_negative_index("cutpoints", "J - 1",
        cutpoints_1dim__);
      current_statement__ = 166;
      mean_PPD_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 166;
      mean_PPD_1dim__ = (stan::math::logical_gt(J, 2) ? J : 1);
      current_statement__ = 166;
      stan::math::validate_non_negative_index("mean_PPD", "J > 2 ? J : 1",
        mean_PPD_1dim__);
      current_statement__ = 167;
      residuals_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 167;
      residuals_1dim__ = (do_residuals ? N : 0);
      current_statement__ = 167;
      stan::math::validate_non_negative_index("residuals",
        "do_residuals ? N : 0", residuals_1dim__);
      current_statement__ = 168;
      zeta_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 168;
      zeta_1dim__ = (J - 1);
      current_statement__ = 168;
      stan::math::validate_non_negative_index("zeta", "J - 1", zeta_1dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = (J - 1) + (u_1dim__ * u_2dim__) + 1 + is_skewed;
  }
  inline std::string model_name() const final {
    return "model_polr";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_polr_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> pi =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(J, DUMMY_VAR__);
      current_statement__ = 1;
      pi = in__.template read_constrain_simplex<
             Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(lp__, J);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> u =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(u_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(u_2dim__,
            DUMMY_VAR__));
      current_statement__ = 2;
      u = in__.template read_constrain_unit_vector<
            std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>,
            jacobian__>(lp__, u_1dim__, u_2dim__);
      local_scalar_t__ R2 = DUMMY_VAR__;
      current_statement__ = 3;
      R2 = in__.template read_constrain_lub<local_scalar_t__,
             jacobian__>((stan::math::logical_gt(K, 1) ? 0 : -1), 1, lp__);
      std::vector<local_scalar_t__> alpha =
        std::vector<local_scalar_t__>(is_skewed, DUMMY_VAR__);
      current_statement__ = 4;
      alpha = in__.template read_constrain_lb<std::vector<local_scalar_t__>,
                jacobian__>(0, lp__, is_skewed);
      Eigen::Matrix<local_scalar_t__,-1,1> beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> cutpoints =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(cutpoints_1dim__,
          DUMMY_VAR__);
      {
        local_scalar_t__ Delta_y = DUMMY_VAR__;
        current_statement__ = 17;
        if (stan::math::logical_gt(K, 1)) {
          current_statement__ = 14;
          Delta_y = stan::math::inv_sqrt((1 - R2));
          current_statement__ = 15;
          stan::model::assign(beta,
            stan::math::multiply(
              stan::math::multiply(
                stan::math::multiply(
                  stan::model::rvalue(u, "u", stan::model::index_uni(1)),
                  stan::math::sqrt(R2)), Delta_y), sqrt_Nm1),
            "assigning variable beta");
        } else {
          current_statement__ = 11;
          Delta_y = stan::math::inv_sqrt((1 - stan::math::square(R2)));
          current_statement__ = 12;
          stan::model::assign(beta, ((R2 * Delta_y) * sqrt_Nm1),
            "assigning variable beta", stan::model::index_uni(1));
        }
        current_statement__ = 18;
        stan::model::assign(cutpoints,
          make_cutpoints(pi, Delta_y, link, pstream__),
          "assigning variable cutpoints");
      }
      {
        current_statement__ = 97;
        if (stan::math::logical_eq(prior_PD, 0)) {
          current_statement__ = 75;
          stan::math::validate_non_negative_index("eta", "N", N);
          Eigen::Matrix<local_scalar_t__,-1,1> eta =
            Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
          current_statement__ = 82;
          if (stan::math::logical_gt(K, 0)) {
            current_statement__ = 80;
            if (dense_X) {
              current_statement__ = 79;
              stan::model::assign(eta,
                stan::math::multiply(
                  stan::model::rvalue(X, "X", stan::model::index_uni(1)),
                  beta), "assigning variable eta");
            } else {
              current_statement__ = 78;
              stan::model::assign(eta,
                stan::math::csr_matrix_times_vector(N, K, w_X, v_X, u_X, beta),
                "assigning variable eta");
            }
          } else {
            current_statement__ = 77;
            stan::model::assign(eta, stan::math::rep_vector(0.0, N),
              "assigning variable eta");
          }
          current_statement__ = 84;
          if (stan::math::logical_eq(has_offset, 1)) {
            current_statement__ = 83;
            stan::model::assign(eta,
              stan::math::add(stan::model::deep_copy(eta), offset_),
              "assigning variable eta");
          }
          current_statement__ = 86;
          if (K_smooth) {
            current_statement__ = 85;
            stan::model::assign(eta,
              stan::math::add(stan::model::deep_copy(eta),
                stan::math::multiply(S, beta_smooth)),
              "assigning variable eta");
          }
          current_statement__ = 95;
          if (stan::math::logical_eq(has_weights, 0)) {
            current_statement__ = 93;
            if (stan::math::logical_eq(is_skewed, 0)) {
              current_statement__ = 92;
              lp_accum__.add(pw_polr(y, eta, cutpoints, link, 1.0, pstream__));
            } else {
              current_statement__ = 91;
              lp_accum__.add(pw_polr(y, eta, cutpoints, link,
                               stan::model::rvalue(alpha, "alpha",
                                 stan::model::index_uni(1)), pstream__));
            }
          } else {
            current_statement__ = 89;
            if (stan::math::logical_eq(is_skewed, 0)) {
              current_statement__ = 88;
              lp_accum__.add(stan::math::dot_product(weights,
                               pw_polr(y, eta, cutpoints, link, 1.0,
                                 pstream__)));
            } else {
              current_statement__ = 87;
              lp_accum__.add(stan::math::dot_product(weights,
                               pw_polr(y, eta, cutpoints, link,
                                 stan::model::rvalue(alpha, "alpha",
                                   stan::model::index_uni(1)), pstream__)));
            }
          }
        }
        current_statement__ = 99;
        if (stan::math::logical_eq(is_constant, 0)) {
          current_statement__ = 98;
          lp_accum__.add(stan::math::dirichlet_lpdf<false>(pi, prior_counts));
        }
        current_statement__ = 104;
        if (stan::math::logical_eq(prior_dist, 1)) {
          current_statement__ = 102;
          if (stan::math::logical_gt(K, 1)) {
            current_statement__ = 101;
            lp_accum__.add(stan::math::beta_lpdf<false>(R2, half_K,
                             regularization));
          } else {
            current_statement__ = 100;
            lp_accum__.add((stan::math::beta_lpdf<false>(
                              stan::math::square(R2), half_K, regularization)
              + stan::math::log(stan::math::abs(R2))));
          }
        }
        current_statement__ = 106;
        if (stan::math::logical_eq(is_skewed, 1)) {
          current_statement__ = 105;
          lp_accum__.add(stan::math::gamma_lpdf<false>(alpha, shape, rate));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_polr_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> pi =
        Eigen::Matrix<double,-1,1>::Constant(J,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      pi = in__.template read_constrain_simplex<
             Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(lp__, J);
      std::vector<Eigen::Matrix<double,-1,1>> u =
        std::vector<Eigen::Matrix<double,-1,1>>(u_1dim__,
          Eigen::Matrix<double,-1,1>::Constant(u_2dim__,
            std::numeric_limits<double>::quiet_NaN()));
      current_statement__ = 2;
      u = in__.template read_constrain_unit_vector<
            std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>,
            jacobian__>(lp__, u_1dim__, u_2dim__);
      double R2 = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 3;
      R2 = in__.template read_constrain_lub<local_scalar_t__,
             jacobian__>((stan::math::logical_gt(K, 1) ? 0 : -1), 1, lp__);
      std::vector<double> alpha =
        std::vector<double>(is_skewed,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 4;
      alpha = in__.template read_constrain_lb<std::vector<local_scalar_t__>,
                jacobian__>(0, lp__, is_skewed);
      Eigen::Matrix<double,-1,1> beta =
        Eigen::Matrix<double,-1,1>::Constant(K,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> cutpoints =
        Eigen::Matrix<double,-1,1>::Constant(cutpoints_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(pi);
      for (int sym1__ = 1; sym1__ <= u_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= u_1dim__; ++sym2__) {
          out__.write(u[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
      out__.write(R2);
      out__.write(alpha);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      {
        double Delta_y = std::numeric_limits<double>::quiet_NaN();
        current_statement__ = 17;
        if (stan::math::logical_gt(K, 1)) {
          current_statement__ = 14;
          Delta_y = stan::math::inv_sqrt((1 - R2));
          current_statement__ = 15;
          stan::model::assign(beta,
            stan::math::multiply(
              stan::math::multiply(
                stan::math::multiply(
                  stan::model::rvalue(u, "u", stan::model::index_uni(1)),
                  stan::math::sqrt(R2)), Delta_y), sqrt_Nm1),
            "assigning variable beta");
        } else {
          current_statement__ = 11;
          Delta_y = stan::math::inv_sqrt((1 - stan::math::square(R2)));
          current_statement__ = 12;
          stan::model::assign(beta, ((R2 * Delta_y) * sqrt_Nm1),
            "assigning variable beta", stan::model::index_uni(1));
        }
        current_statement__ = 18;
        stan::model::assign(cutpoints,
          make_cutpoints(pi, Delta_y, link, pstream__),
          "assigning variable cutpoints");
      }
      if (emit_transformed_parameters__) {
        out__.write(beta);
        out__.write(cutpoints);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,1> mean_PPD =
        Eigen::Matrix<double,-1,1>::Constant(mean_PPD_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 7;
      stan::model::assign(mean_PPD,
        stan::math::rep_vector(0, (stan::math::logical_gt(J, 2) ? J : 1)),
        "assigning variable mean_PPD");
      Eigen::Matrix<double,-1,1> residuals =
        Eigen::Matrix<double,-1,1>::Constant(residuals_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> zeta =
        Eigen::Matrix<double,-1,1>::Constant(zeta_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 22;
      if (dense_X) {
        current_statement__ = 21;
        stan::model::assign(zeta,
          stan::math::add(cutpoints, stan::math::dot_product(xbar, beta)),
          "assigning variable zeta");
      } else {
        current_statement__ = 20;
        stan::model::assign(zeta, cutpoints, "assigning variable zeta");
      }
      current_statement__ = 24;
      if (stan::math::logical_eq(J, 2)) {
        current_statement__ = 23;
        stan::model::assign(zeta,
          stan::math::multiply(stan::model::deep_copy(zeta), -1.0),
          "assigning variable zeta");
      }
      {
        current_statement__ = 25;
        stan::math::validate_non_negative_index("eta", "N", N);
        Eigen::Matrix<double,-1,1> eta =
          Eigen::Matrix<double,-1,1>::Constant(N,
            std::numeric_limits<double>::quiet_NaN());
        current_statement__ = 32;
        if (stan::math::logical_gt(K, 0)) {
          current_statement__ = 30;
          if (dense_X) {
            current_statement__ = 29;
            stan::model::assign(eta,
              stan::math::multiply(
                stan::model::rvalue(X, "X", stan::model::index_uni(1)), beta),
              "assigning variable eta");
          } else {
            current_statement__ = 28;
            stan::model::assign(eta,
              stan::math::csr_matrix_times_vector(N, K, w_X, v_X, u_X, beta),
              "assigning variable eta");
          }
        } else {
          current_statement__ = 27;
          stan::model::assign(eta, stan::math::rep_vector(0.0, N),
            "assigning variable eta");
        }
        current_statement__ = 34;
        if (stan::math::logical_eq(has_offset, 1)) {
          current_statement__ = 33;
          stan::model::assign(eta,
            stan::math::add(stan::model::deep_copy(eta), offset_),
            "assigning variable eta");
        }
        current_statement__ = 36;
        if (K_smooth) {
          current_statement__ = 35;
          stan::model::assign(eta,
            stan::math::add(stan::model::deep_copy(eta),
              stan::math::multiply(S, beta_smooth)), "assigning variable eta");
        }
        current_statement__ = 72;
        for (int n = 1; n <= N; ++n) {
          int y_tilde = std::numeric_limits<int>::min();
          current_statement__ = 38;
          stan::math::validate_non_negative_index("theta", "J", J);
          Eigen::Matrix<double,-1,1> theta =
            Eigen::Matrix<double,-1,1>::Constant(J,
              std::numeric_limits<double>::quiet_NaN());
          double previous = std::numeric_limits<double>::quiet_NaN();
          double first = std::numeric_limits<double>::quiet_NaN();
          current_statement__ = 41;
          first = CDF_polr(
                    (stan::model::rvalue(cutpoints, "cutpoints",
                       stan::model::index_uni(1)) -
                    stan::model::rvalue(eta, "eta", stan::model::index_uni(n))),
                    link, pstream__);
          current_statement__ = 42;
          previous = first;
          current_statement__ = 45;
          if (is_skewed) {
            current_statement__ = 44;
            stan::model::assign(theta,
              stan::math::pow(first,
                stan::model::rvalue(alpha, "alpha", stan::model::index_uni(1))),
              "assigning variable theta", stan::model::index_uni(1));
          } else {
            current_statement__ = 43;
            stan::model::assign(theta, first, "assigning variable theta",
              stan::model::index_uni(1));
          }
          current_statement__ = 50;
          for (int j = 2; j <= (J - 1); ++j) {
            double current = std::numeric_limits<double>::quiet_NaN();
            current_statement__ = 46;
            current = CDF_polr(
                        (stan::model::rvalue(cutpoints, "cutpoints",
                           stan::model::index_uni(j)) -
                        stan::model::rvalue(eta, "eta",
                          stan::model::index_uni(n))), link, pstream__);
            current_statement__ = 47;
            stan::model::assign(theta, (current - previous),
              "assigning variable theta", stan::model::index_uni(j));
            current_statement__ = 48;
            previous = current;
          }
          current_statement__ = 53;
          if (stan::math::logical_eq(is_skewed, 0)) {
            current_statement__ = 52;
            stan::model::assign(theta, (1 - previous),
              "assigning variable theta", stan::model::index_uni(J));
          } else {
            current_statement__ = 51;
            stan::model::assign(theta, (1 -
              stan::math::pow(previous,
                stan::model::rvalue(alpha, "alpha", stan::model::index_uni(1)))),
              "assigning variable theta", stan::model::index_uni(J));
          }
          current_statement__ = 61;
          if ((stan::math::primitive_value(
                 stan::math::logical_lte(previous, 0))
              ||
              stan::math::primitive_value(
                stan::math::logical_gte(previous, 1)))) {} else {
                                                           current_statement__ = 59;
                                                           if (stan::math::logical_eq(
                                                                 J, 2)) {
                                                             current_statement__ = 57;
                                                             stan::model::assign(
                                                               mean_PPD,
                                                               (stan::model::rvalue(
                                                                  mean_PPD,
                                                                  "mean_PPD",
                                                                  stan::model::index_uni(
                                                                    1)) +
                                                               stan::math::bernoulli_rng(
                                                                 stan::model::rvalue(
                                                                   theta,
                                                                   "theta",
                                                                   stan::model::index_uni(
                                                                    J)),
                                                                 base_rng__)),
                                                               "assigning variable mean_PPD",
                                                               stan::model::index_uni(
                                                                 1));
                                                           } else {
                                                             current_statement__ = 54;
                                                             y_tilde = 
                                                               stan::math::categorical_rng(
                                                                 theta,
                                                                 base_rng__);
                                                             current_statement__ = 55;
                                                             stan::model::assign(
                                                               mean_PPD,
                                                               (stan::model::rvalue(
                                                                  mean_PPD,
                                                                  "mean_PPD",
                                                                  stan::model::index_uni(
                                                                    y_tilde))
                                                               + 1),
                                                               "assigning variable mean_PPD",
                                                               stan::model::index_uni(
                                                                 y_tilde));
                                                           }
          }
          current_statement__ = 70;
          if (do_residuals) {
            double ystar = std::numeric_limits<double>::quiet_NaN();
            current_statement__ = 67;
            if (stan::math::logical_eq(
                  stan::model::rvalue(y, "y", stan::model::index_uni(n)), 1)) {
              current_statement__ = 66;
              ystar = draw_ystar_rng(stan::math::negative_infinity(),
                        stan::model::rvalue(cutpoints, "cutpoints",
                          stan::model::index_uni(1)),
                        stan::model::rvalue(eta, "eta",
                          stan::model::index_uni(n)), link, base_rng__,
                        pstream__);
            } else {
              current_statement__ = 65;
              if (stan::math::logical_eq(
                    stan::model::rvalue(y, "y", stan::model::index_uni(n)), J)) {
                current_statement__ = 64;
                ystar = draw_ystar_rng(
                          stan::model::rvalue(cutpoints, "cutpoints",
                            stan::model::index_uni((J - 1))),
                          stan::math::positive_infinity(),
                          stan::model::rvalue(eta, "eta",
                            stan::model::index_uni(n)), link, base_rng__,
                          pstream__);
              } else {
                current_statement__ = 63;
                ystar = draw_ystar_rng(
                          stan::model::rvalue(cutpoints, "cutpoints",
                            stan::model::index_uni(
                              (stan::model::rvalue(y, "y",
                                 stan::model::index_uni(n)) - 1))),
                          stan::model::rvalue(cutpoints, "cutpoints",
                            stan::model::index_uni(
                              stan::model::rvalue(y, "y",
                                stan::model::index_uni(n)))),
                          stan::model::rvalue(eta, "eta",
                            stan::model::index_uni(n)), link, base_rng__,
                          pstream__);
              }
            }
            current_statement__ = 68;
            stan::model::assign(residuals, (ystar -
              stan::model::rvalue(eta, "eta", stan::model::index_uni(n))),
              "assigning variable residuals", stan::model::index_uni(n));
          }
        }
        current_statement__ = 73;
        stan::model::assign(mean_PPD,
          stan::math::divide(stan::model::deep_copy(mean_PPD), (N + 0.0)),
          "assigning variable mean_PPD");
      }
      out__.write(mean_PPD);
      out__.write(residuals);
      out__.write(zeta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> pi =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(J, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(pi,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(J),
        "assigning variable pi");
      out__.write_free_simplex(pi);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> u =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(u_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(u_2dim__,
            DUMMY_VAR__));
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= u_2dim__; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= u_1dim__; ++sym2__) {
          current_statement__ = 2;
          stan::model::assign(u, in__.read<local_scalar_t__>(),
            "assigning variable u", stan::model::index_uni(sym2__),
            stan::model::index_uni(sym1__));
        }
      }
      out__.write_free_unit_vector(u);
      local_scalar_t__ R2 = DUMMY_VAR__;
      current_statement__ = 3;
      R2 = in__.read<local_scalar_t__>();
      out__.write_free_lub((stan::math::logical_gt(K, 1) ? 0 : -1), 1, R2);
      std::vector<local_scalar_t__> alpha =
        std::vector<local_scalar_t__>(is_skewed, DUMMY_VAR__);
      current_statement__ = 4;
      stan::model::assign(alpha,
        in__.read<std::vector<local_scalar_t__>>(is_skewed),
        "assigning variable alpha");
      out__.write_free_lb(0, alpha);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "pi", "double",
        std::vector<size_t>{static_cast<size_t>(J)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "u", "double",
        std::vector<size_t>{static_cast<size_t>(u_1dim__),
          static_cast<size_t>(u_2dim__)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "R2", "double",
        std::vector<size_t>{});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "alpha", "double",
        std::vector<size_t>{static_cast<size_t>(is_skewed)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> pi =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(J, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> pi_flat__;
        current_statement__ = 1;
        pi_flat__ = context__.vals_r("pi");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(pi, pi_flat__[(pos__ - 1)],
            "assigning variable pi", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_simplex(pi);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> u =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(u_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(u_2dim__,
            DUMMY_VAR__));
      {
        std::vector<local_scalar_t__> u_flat__;
        current_statement__ = 2;
        u_flat__ = context__.vals_r("u");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= u_2dim__; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= u_1dim__; ++sym2__) {
            current_statement__ = 2;
            stan::model::assign(u, u_flat__[(pos__ - 1)],
              "assigning variable u", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 2;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write_free_unit_vector(u);
      local_scalar_t__ R2 = DUMMY_VAR__;
      current_statement__ = 3;
      R2 = context__.vals_r("R2")[(1 - 1)];
      out__.write_free_lub((stan::math::logical_gt(K, 1) ? 0 : -1), 1, R2);
      std::vector<local_scalar_t__> alpha =
        std::vector<local_scalar_t__>(is_skewed, DUMMY_VAR__);
      current_statement__ = 4;
      alpha = context__.vals_r("alpha");
      out__.write_free_lb(0, alpha);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"pi", "u", "R2", "alpha"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"beta", "cutpoints"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"mean_PPD", "residuals", "zeta"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(J)},
                std::vector<size_t>{static_cast<size_t>(u_1dim__),
                  static_cast<size_t>(u_2dim__)}, std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(is_skewed)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(K)},
             std::vector<size_t>{static_cast<size_t>(cutpoints_1dim__)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(mean_PPD_1dim__)},
             std::vector<size_t>{static_cast<size_t>(residuals_1dim__)},
             std::vector<size_t>{static_cast<size_t>(zeta_1dim__)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      param_names__.emplace_back(std::string() + "pi" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= u_2dim__; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= u_1dim__; ++sym2__) {
        param_names__.emplace_back(std::string() + "u" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    param_names__.emplace_back(std::string() + "R2");
    for (int sym1__ = 1; sym1__ <= is_skewed; ++sym1__) {
      param_names__.emplace_back(std::string() + "alpha" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        param_names__.emplace_back(std::string() + "beta" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= cutpoints_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "cutpoints" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= mean_PPD_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "mean_PPD" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= residuals_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "residuals" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= zeta_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "zeta" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= (J - 1); ++sym1__) {
      param_names__.emplace_back(std::string() + "pi" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= u_2dim__; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= u_1dim__; ++sym2__) {
        param_names__.emplace_back(std::string() + "u" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    param_names__.emplace_back(std::string() + "R2");
    for (int sym1__ = 1; sym1__ <= is_skewed; ++sym1__) {
      param_names__.emplace_back(std::string() + "alpha" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        param_names__.emplace_back(std::string() + "beta" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= cutpoints_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "cutpoints" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= mean_PPD_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "mean_PPD" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= residuals_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "residuals" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= zeta_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "zeta" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"pi\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(J) + "},\"block\":\"parameters\"},{\"name\":\"u\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(u_1dim__) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(u_2dim__) + "}},\"block\":\"parameters\"},{\"name\":\"R2\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(is_skewed) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"transformed_parameters\"},{\"name\":\"cutpoints\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(cutpoints_1dim__) + "},\"block\":\"transformed_parameters\"},{\"name\":\"mean_PPD\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(mean_PPD_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"residuals\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(residuals_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"zeta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(zeta_1dim__) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"pi\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string((J -1)) + "},\"block\":\"parameters\"},{\"name\":\"u\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(u_1dim__) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(u_2dim__) + "}},\"block\":\"parameters\"},{\"name\":\"R2\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(is_skewed) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"transformed_parameters\"},{\"name\":\"cutpoints\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(cutpoints_1dim__) + "},\"block\":\"transformed_parameters\"},{\"name\":\"mean_PPD\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(mean_PPD_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"residuals\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(residuals_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"zeta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(zeta_1dim__) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((J + (u_1dim__ * u_2dim__)) + 1) +
      is_skewed);
    const size_t num_transformed = emit_transformed_parameters * ((K +
      cutpoints_1dim__));
    const size_t num_gen_quantities = emit_generated_quantities *
      (((mean_PPD_1dim__ + residuals_1dim__) + zeta_1dim__));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((J + (u_1dim__ * u_2dim__)) + 1) +
      is_skewed);
    const size_t num_transformed = emit_transformed_parameters * ((K +
      cutpoints_1dim__));
    const size_t num_gen_quantities = emit_generated_quantities *
      (((mean_PPD_1dim__ + residuals_1dim__) + zeta_1dim__));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_polr_namespace::model_polr;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_polr_namespace::profiles__;
}
#endif
#endif
