% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brain_extraction.R
\name{brain_extraction}
\alias{brain_extraction}
\alias{antspynet_brain_extraction}
\alias{brain_mask}
\title{Extract brain and strip skull}
\usage{
antspynet_brain_extraction(
  x,
  modality = c("t1", "t1nobrainer", "t1combined", "flair", "t2", "t2star", "bold", "fa",
    "t1t2infant", "t1infant", "t2infant"),
  verbose = FALSE
)

brain_mask(
  x,
  work_path = tempfile(pattern = "rpyant_brain_extraction_"),
  verbose = TRUE,
  auto_clean = TRUE
)

brain_extraction(
  x,
  skull_alpha = 0,
  threshold_quantile = 0.85,
  ...,
  verbose = TRUE
)
}
\arguments{
\item{x}{input image or image path}

\item{modality}{modality type, used by \code{antspynet_brain_extraction} only}

\item{verbose}{whether to print out process to the screen}

\item{work_path}{working directory; default is temporary path}

\item{auto_clean}{whether to automatically clean the working path if
the path is temporary; default is true}

\item{skull_alpha}{used by \code{brain_extraction}, the opacity of the
skull in the final image; default is 0 (completely strip the skull);
set to values between 0 to 1 to add skulls (in such case, the background
noises will be set to 0)}

\item{threshold_quantile}{used only when \code{skull_alpha} is positive to
remove the noises}

\item{...}{see \code{work_path} and \code{auto_clean}}
}
\value{
\describe{
\item{\code{brain_mask}}{Brain mask image}
\item{\code{brain_extraction}}{extracted brain}
\item{\code{antspynet_brain_extraction}}{Brain mask image}
}
}
\description{
Function \code{brain_mask} and \code{brain_extraction} use the \code{ants}
base package.
Function \code{antspynet_brain_extraction} uses \code{antspynet} to extract
the brain using deep neural network. This requires additional configuration.
Print \code{antspynet$brain_extraction} to see the original documentation.
}
