/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.TsLags;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.ModifierFactory;

public class LagsFactory
implements ModifierFactory<TsLags> {
    static LagsFactory FACTORY = new LagsFactory();

    private LagsFactory() {
    }

    @Override
    public TsDomain needFor(TsLags lags, TsDomain domain) {
        TsPeriod start = domain.getStartPeriod().plus((long)(-lags.getLastLag()));
        return TsDomain.of((TsPeriod)start, (int)(domain.getLength() + lags.getLagsCount() - 1));
    }

    @Override
    public TimeSeriesDomain needForGeneric(TsLags lags, TimeSeriesDomain domain) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean fill(TsLags modifier, TsPeriod start, FastMatrix input, FastMatrix output) {
        int nlags = modifier.getLagsCount();
        int k = 0;
        for (int i = 0; i < nlags; ++i) {
            int j = 0;
            while (j < input.getColumnsCount()) {
                output.column(k).copy(input.column(j).drop(nlags - i - 1, i));
                ++j;
                ++k;
            }
        }
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(TsLags var, D domain, FastMatrix input, FastMatrix output) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

