/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import java.util.concurrent.atomic.AtomicReference;
import jdplus.toolkit.base.api.processing.DiagnosticsConfiguration;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class AdvancedResidualSeasonalityDiagnosticsConfiguration
implements DiagnosticsConfiguration {
    private static final AtomicReference<AdvancedResidualSeasonalityDiagnosticsConfiguration> DEFAULT = new AtomicReference<AdvancedResidualSeasonalityDiagnosticsConfiguration>(AdvancedResidualSeasonalityDiagnosticsConfiguration.builder().build());
    public static final boolean ACTIVE = true;
    private final boolean active;
    public static final double SEV = 0.001;
    public static final double BAD = 0.01;
    public static final double UNC = 0.05;
    private final double severeThreshold;
    private final double badThreshold;
    private final double uncertainThreshold;
    private final boolean qs;
    private final boolean ftest;

    public static void setDefault(AdvancedResidualSeasonalityDiagnosticsConfiguration config) {
        DEFAULT.set(config);
    }

    public static AdvancedResidualSeasonalityDiagnosticsConfiguration getDefault() {
        return DEFAULT.get();
    }

    public static Builder builder() {
        return new Builder().active(true).severeThreshold(0.001).badThreshold(0.01).uncertainThreshold(0.05).qs(true).ftest(true);
    }

    public void check() {
        if (this.severeThreshold < this.badThreshold || this.badThreshold < this.uncertainThreshold || this.uncertainThreshold < 0.0) {
            throw new IllegalArgumentException();
        }
    }

    public DiagnosticsConfiguration activate(boolean active) {
        if (this.active == active) {
            return this;
        }
        return this.toBuilder().active(active).build();
    }

    @Generated
    AdvancedResidualSeasonalityDiagnosticsConfiguration(boolean active, double severeThreshold, double badThreshold, double uncertainThreshold, boolean qs, boolean ftest) {
        this.active = active;
        this.severeThreshold = severeThreshold;
        this.badThreshold = badThreshold;
        this.uncertainThreshold = uncertainThreshold;
        this.qs = qs;
        this.ftest = ftest;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().active(this.active).severeThreshold(this.severeThreshold).badThreshold(this.badThreshold).uncertainThreshold(this.uncertainThreshold).qs(this.qs).ftest(this.ftest);
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public double getSevereThreshold() {
        return this.severeThreshold;
    }

    @Generated
    public double getBadThreshold() {
        return this.badThreshold;
    }

    @Generated
    public double getUncertainThreshold() {
        return this.uncertainThreshold;
    }

    @Generated
    public boolean isQs() {
        return this.qs;
    }

    @Generated
    public boolean isFtest() {
        return this.ftest;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdvancedResidualSeasonalityDiagnosticsConfiguration)) {
            return false;
        }
        AdvancedResidualSeasonalityDiagnosticsConfiguration other = (AdvancedResidualSeasonalityDiagnosticsConfiguration)o;
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (Double.compare(this.getSevereThreshold(), other.getSevereThreshold()) != 0) {
            return false;
        }
        if (Double.compare(this.getBadThreshold(), other.getBadThreshold()) != 0) {
            return false;
        }
        if (Double.compare(this.getUncertainThreshold(), other.getUncertainThreshold()) != 0) {
            return false;
        }
        if (this.isQs() != other.isQs()) {
            return false;
        }
        return this.isFtest() == other.isFtest();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        long $severeThreshold = Double.doubleToLongBits(this.getSevereThreshold());
        result = result * 59 + (int)($severeThreshold >>> 32 ^ $severeThreshold);
        long $badThreshold = Double.doubleToLongBits(this.getBadThreshold());
        result = result * 59 + (int)($badThreshold >>> 32 ^ $badThreshold);
        long $uncertainThreshold = Double.doubleToLongBits(this.getUncertainThreshold());
        result = result * 59 + (int)($uncertainThreshold >>> 32 ^ $uncertainThreshold);
        result = result * 59 + (this.isQs() ? 79 : 97);
        result = result * 59 + (this.isFtest() ? 79 : 97);
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "AdvancedResidualSeasonalityDiagnosticsConfiguration(active=" + this.isActive() + ", severeThreshold=" + this.getSevereThreshold() + ", badThreshold=" + this.getBadThreshold() + ", uncertainThreshold=" + this.getUncertainThreshold() + ", qs=" + this.isQs() + ", ftest=" + this.isFtest() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private boolean active;
        @Generated
        private double severeThreshold;
        @Generated
        private double badThreshold;
        @Generated
        private double uncertainThreshold;
        @Generated
        private boolean qs;
        @Generated
        private boolean ftest;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder active(boolean active) {
            this.active = active;
            return this;
        }

        @Generated
        public @NonNull Builder severeThreshold(double severeThreshold) {
            this.severeThreshold = severeThreshold;
            return this;
        }

        @Generated
        public @NonNull Builder badThreshold(double badThreshold) {
            this.badThreshold = badThreshold;
            return this;
        }

        @Generated
        public @NonNull Builder uncertainThreshold(double uncertainThreshold) {
            this.uncertainThreshold = uncertainThreshold;
            return this;
        }

        @Generated
        public @NonNull Builder qs(boolean qs) {
            this.qs = qs;
            return this;
        }

        @Generated
        public @NonNull Builder ftest(boolean ftest) {
            this.ftest = ftest;
            return this;
        }

        @Generated
        public @NonNull AdvancedResidualSeasonalityDiagnosticsConfiguration build() {
            return new AdvancedResidualSeasonalityDiagnosticsConfiguration(this.active, this.severeThreshold, this.badThreshold, this.uncertainThreshold, this.qs, this.ftest);
        }

        @Generated
        public @NonNull String toString() {
            return "AdvancedResidualSeasonalityDiagnosticsConfiguration.Builder(active=" + this.active + ", severeThreshold=" + this.severeThreshold + ", badThreshold=" + this.badThreshold + ", uncertainThreshold=" + this.uncertainThreshold + ", qs=" + this.qs + ", ftest=" + this.ftest + ")";
        }
    }
}

