% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_description.R
\name{update_news_md}
\alias{update_news_md}
\title{Update \code{NEWS.md} for a new release}
\usage{
update_news_md(path, version_number, verbose = TRUE)
}
\arguments{
\item{path}{[\link[base]{character}] Path to the package root directory.}

\item{version_number}{[\link[base]{character}] Current version number string
(e.g. \code{"1.2.3"}).}

\item{verbose}{[\link[base]{logical}] Whether to print current and new
remote fields (default: \code{TRUE}).}
}
\value{
Invisibly returns \code{TRUE} if the file was successfully updated.
}
\description{
Modify the \code{NEWS.md} file of a package to replace the \code{"Unreleased"}
section with a new version heading and update GitHub comparison links.
}
\details{
The argument \code{version_number} is the new version number to update the
changelog.
}
\examples{
path_rjd3workspace <- file.path(tempdir(), "rjd3workspace")
file.copy(
    from = system.file("rjd3workspace", package = "releaser"),
    to = dirname(path_rjd3workspace),
    recursive = TRUE
)

update_news_md(path = path_rjd3workspace, version_number = "1.2.3")

}
