% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unicode-general-category-classes.R,
%   R/unicode-general-category-constants.R
\docType{data}
\name{up_alphabetic}
\alias{up_alphabetic}
\alias{up_ascii_hex_digit}
\alias{up_bidi_control}
\alias{up_bidi_mirrored}
\alias{up_case_ignorable}
\alias{up_case_sensitive}
\alias{up_cased}
\alias{up_changes_when_casefolded}
\alias{up_changes_when_casemapped}
\alias{up_changes_when_lowercased}
\alias{up_changes_when_nfkc_casefolded}
\alias{up_changes_when_titlecased}
\alias{up_changes_when_uppercased}
\alias{up_dash}
\alias{up_default_ignorable_code_point}
\alias{up_deprecated}
\alias{up_diacritic}
\alias{up_extender}
\alias{up_hex_digit}
\alias{up_hyphen}
\alias{up_id_continue}
\alias{up_id_start}
\alias{up_ideographic}
\alias{up_lowercase}
\alias{up_math}
\alias{up_noncharacter_code_point}
\alias{up_posix_alnum}
\alias{up_posix_blank}
\alias{up_posix_graph}
\alias{up_posix_print}
\alias{up_posix_xdigit}
\alias{up_quotation_mark}
\alias{up_soft_dotted}
\alias{up_terminal_punctuation}
\alias{up_uppercase}
\alias{up_white_space}
\alias{UnicodeProperty}
\alias{unicode_property}
\alias{UP_ALPHABETIC}
\alias{UP_ASCII_HEX_DIGIT}
\alias{UP_BIDI_CONTROL}
\alias{UP_BIDI_MIRRORED}
\alias{UP_DASH}
\alias{UP_DEFAULT_IGNORABLE_CODE_POINT}
\alias{UP_DEPRECATED}
\alias{UP_DIACRITIC}
\alias{UP_EXTENDER}
\alias{UP_HEX_DIGIT}
\alias{UP_HYPHEN}
\alias{UP_ID_CONTINUE}
\alias{UP_ID_START}
\alias{UP_IDEOGRAPHIC}
\alias{UP_LOWERCASE}
\alias{UP_MATH}
\alias{UP_NONCHARACTER_CODE_POINT}
\alias{UP_QUOTATION_MARK}
\alias{UP_SOFT_DOTTED}
\alias{UP_TERMINAL_PUNCTUATION}
\alias{UP_UPPERCASE}
\alias{UP_WHITE_SPACE}
\alias{UP_CASE_SENSITIVE}
\alias{UP_POSIX_ALNUM}
\alias{UP_POSIX_BLANK}
\alias{UP_POSIX_GRAPH}
\alias{UP_POSIX_PRINT}
\alias{UP_POSIX_XDIGIT}
\alias{UP_CASED}
\alias{UP_CASE_IGNORABLE}
\alias{UP_CHANGES_WHEN_LOWERCASED}
\alias{UP_CHANGES_WHEN_UPPERCASED}
\alias{UP_CHANGES_WHEN_TITLECASED}
\alias{UP_CHANGES_WHEN_CASEFOLDED}
\alias{UP_CHANGES_WHEN_CASEMAPPED}
\alias{UP_CHANGES_WHEN_NFKC_CASEFOLDED}
\title{Unicode Properties}
\format{
An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.
}
\usage{
up_alphabetic(lo, hi, char_class = TRUE)

up_ascii_hex_digit(lo, hi, char_class = TRUE)

up_bidi_control(lo, hi, char_class = TRUE)

up_bidi_mirrored(lo, hi, char_class = TRUE)

up_case_ignorable(lo, hi, char_class = TRUE)

up_case_sensitive(lo, hi, char_class = TRUE)

up_cased(lo, hi, char_class = TRUE)

up_changes_when_casefolded(lo, hi, char_class = TRUE)

up_changes_when_casemapped(lo, hi, char_class = TRUE)

up_changes_when_lowercased(lo, hi, char_class = TRUE)

up_changes_when_nfkc_casefolded(lo, hi, char_class = TRUE)

up_changes_when_titlecased(lo, hi, char_class = TRUE)

up_changes_when_uppercased(lo, hi, char_class = TRUE)

up_dash(lo, hi, char_class = TRUE)

up_default_ignorable_code_point(lo, hi, char_class = TRUE)

up_deprecated(lo, hi, char_class = TRUE)

up_diacritic(lo, hi, char_class = TRUE)

up_extender(lo, hi, char_class = TRUE)

up_hex_digit(lo, hi, char_class = TRUE)

up_hyphen(lo, hi, char_class = TRUE)

up_id_continue(lo, hi, char_class = TRUE)

up_id_start(lo, hi, char_class = TRUE)

up_ideographic(lo, hi, char_class = TRUE)

up_lowercase(lo, hi, char_class = TRUE)

up_math(lo, hi, char_class = TRUE)

up_noncharacter_code_point(lo, hi, char_class = TRUE)

up_posix_alnum(lo, hi, char_class = TRUE)

up_posix_blank(lo, hi, char_class = TRUE)

up_posix_graph(lo, hi, char_class = TRUE)

up_posix_print(lo, hi, char_class = TRUE)

up_posix_xdigit(lo, hi, char_class = TRUE)

up_quotation_mark(lo, hi, char_class = TRUE)

up_soft_dotted(lo, hi, char_class = TRUE)

up_terminal_punctuation(lo, hi, char_class = TRUE)

up_uppercase(lo, hi, char_class = TRUE)

up_white_space(lo, hi, char_class = TRUE)

UP_ALPHABETIC

UP_ASCII_HEX_DIGIT

UP_BIDI_CONTROL

UP_BIDI_MIRRORED

UP_DASH

UP_DEFAULT_IGNORABLE_CODE_POINT

UP_DEPRECATED

UP_DIACRITIC

UP_EXTENDER

UP_HEX_DIGIT

UP_HYPHEN

UP_ID_CONTINUE

UP_ID_START

UP_IDEOGRAPHIC

UP_LOWERCASE

UP_MATH

UP_NONCHARACTER_CODE_POINT

UP_QUOTATION_MARK

UP_SOFT_DOTTED

UP_TERMINAL_PUNCTUATION

UP_UPPERCASE

UP_WHITE_SPACE

UP_CASE_SENSITIVE

UP_POSIX_ALNUM

UP_POSIX_BLANK

UP_POSIX_GRAPH

UP_POSIX_PRINT

UP_POSIX_XDIGIT

UP_CASED

UP_CASE_IGNORABLE

UP_CHANGES_WHEN_LOWERCASED

UP_CHANGES_WHEN_UPPERCASED

UP_CHANGES_WHEN_TITLECASED

UP_CHANGES_WHEN_CASEFOLDED

UP_CHANGES_WHEN_CASEMAPPED

UP_CHANGES_WHEN_NFKC_CASEFOLDED
}
\arguments{
\item{lo}{A non-negative integer. Minimum number of repeats, when grouped.}

\item{hi}{positive integer. Maximum number of repeats, when grouped.}

\item{char_class}{\code{TRUE} or \code{FALSE}. Should the values be wrapped
into a character class?}
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
Match a Unicode Property.
}
\examples{
# Classes
up_math()
up_posix_alnum()
up_changes_when_uppercased()
up_diacritic()

# With repetition
ugc_nonspacing_mark(3, 6)
up_quotation_mark(1, Inf)
up_posix_xdigit(0, Inf)

# Without a class wrapper
up_hyphen(char_class = FALSE)

# Constants
UP_ALPHABETIC
UP_DASH
UP_POSIX_ALNUM
UP_CHANGES_WHEN_LOWERCASED

\dontrun{
# All the Unicode properties.
# Not run, since it generates lots of output
ls("package:rebus.unicode", pattern = "^up")
}

# Usage
# Hello in Samoan, Serbian, Persian, Simplified Chinese
hello <- "t\u101lofa, \u437\u434\u440\u430\u432\u43e, \u633\u644\u627\u645, \u4f60\u597d"
stringi::stri_extract_all_regex(hello, up_alphabetic(1, Inf))
stringi::stri_extract_all_regex(hello, up_case_sensitive(1, Inf))
}
\references{
Table 12 of the Unicode Standard Annex #44 defines the Unicode
General Categories.
\url{http://www.unicode.org/reports/tr44/}

You can see which characters are contained in a category by visiting, e.g.,
\url{http://www.fileformat.info/info/unicode/category/Nd/list.htm}
}
\seealso{
\code{\link{unicode_general_category}}, \code{\link{Unicode}},
\code{\link[stringi]{stringi-search-charclass}}
}
\keyword{datasets}
