% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrrp_get_dates.R
\name{hrrp_get_dates}
\alias{hrrp_get_dates}
\title{Find relevant dates from the Hospital Readmissions Reduction Program (HRRP)}
\usage{
hrrp_get_dates(ref, period = c("payment", "performance"), discharge = TRUE)
}
\arguments{
\item{ref}{A \code{Date} object}

\item{period}{The program period to extract dates for. One of \code{c("payment", "performance")}.}

\item{discharge}{Should the \code{ref} date be taken as a \emph{discharge} date? Defaults to \code{TRUE}. If \code{FALSE}, it's taken to be a penalty/program date.}
}
\value{
A \link[tibble:tibble]{tibble::tibble}
}
\description{
Identifies key dates (see \link{hrrp_keydates}) from the \href{https://www.cms.gov/medicare/payment/prospective-payment-systems/acute-inpatient-pps/hospital-readmissions-reduction-program-hrrp}{Hospital Readmissions Reduction Program (HRRP)}
that are associated with an input reference date, such as performance and payment periods.
}
\examples{
my_date <- as.Date("2022-01-01")

# What are the payment periods for this discharge?
hrrp_get_dates(my_date, period = "payment", discharge = TRUE)

# What performance periods is this discharge included in?
hrrp_get_dates(my_date, period = "performance", discharge = TRUE)

# What is the payment period overlapping this date?
hrrp_get_dates(my_date, period = "payment", discharge = FALSE)

# What is the performance period whose penalty period overlaps this date?
hrrp_get_dates(my_date, period = "performance", discharge = FALSE)

# What is the performance period for current penalty enforcement?
hrrp_get_dates(Sys.Date(), period = "performance", discharge = FALSE)
}
\seealso{
\link{hrrp_keydates}
}
