% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webdav.R
\name{wd_setwd}
\alias{wd_setwd}
\title{Set working directory}
\usage{
wd_setwd(req, directory)
}
\arguments{
\item{req}{request handle obtained from \code{\link{wd_connect}}}

\item{directory}{WebDAV directory}
}
\value{
modified request
}
\description{
If the directory path starts with a forward slash, then it is set from
the WebDAV's root directory. Otherwise it's set in the current directory.
}
\details{
If the directory does not exist, then the request is not modified.

Notice: One has to (re)assign the returned request, as it is not
modified in place.
}
\examples{
\dontrun{
req <- wd_setwd(req, "/maindir")
req <- wd_setwd(req, "subdir")
req <- wd_setwd(req, "/othermain")
}
}
