% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-ecacwdi.R, R/op-cdo-eca_cwdi.R
\name{ecacwdi}
\alias{ecacwdi}
\alias{cdo_eca_cwdi}
\title{Cold wave duration index wrt mean of reference period}
\usage{
cdo_eca_cwdi(ifile1, ifile2, nday = NULL, T = NULL, ofile = NULL)
}
\arguments{
\item{ifile1, ifile2}{Strings with the path to the input files.}

\item{nday}{INTEGER - Number of consecutive days (default: nday = 6)}

\item{T}{FLOAT - Temperature offset (unit: °C; default: T = 5°C)}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
Let infile1 be a time series of the daily minimum temperature TN, and let infile2 be the mean TNnorm of daily minimum temperatures for any period used as reference. Then counted is the number of days where, in intervals of at least nday consecutive days, TN < TNnorm - T. The numbers nday and T are optional parameters with default nday = 6 and T = 5°C. A further output variable is the number of cold waves longer than or equal to nday days. TNnorm is calculated as the mean of minimum temperatures of a five day window centred on each calendar day of a given climate reference period. Note that both TN and TNnorm have to be given in the same units. The date information of a timestep in outfile is the date of the last contributing timestep in infile1.
}
