% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow-compose_channel.R
\name{compose_channel}
\alias{compose_channel}
\title{Compose a phantom channel from existing electrodes}
\usage{
compose_channel(
  subject,
  number,
  from,
  weights = rep(1/length(from), length(from)),
  normalize = FALSE,
  force = FALSE,
  label = sprintf("Composed-\%s", number),
  signal_type = c("auto", "LFP", "Spike", "EKG", "Auxiliary", "Unknown")
)
}
\arguments{
\item{subject}{'RAVE' subject}

\item{number}{new channel number, must be positive integer, cannot be
existing electrode channel numbers}

\item{from}{a vector of electrode channels that is used to compose this
new channel, must be non-empty; see \code{weights} if these channels are
not equally weighted.}

\item{weights}{numerical weights used on each \code{from} channels; the
length of \code{weights} must equals to the length of \code{from};
default is equally weighted for each channel (mean of
\code{from} channels).}

\item{normalize}{whether to normalize the weights such that the composed
channel has the same variance as \code{from} channels; default is false}

\item{force}{whether to overwrite existing composed channel if it exists;
default is false. By specifying \code{force=TRUE}, users are risking breaking
the data integrity since any analysis based on the composed channel is
no longer reproducible. Also users cannot overwrite original channels
under any circumstances.}

\item{label}{the label for the composed channel; will be stored at
\code{'electrodes.csv'}}

\item{signal_type}{signal type of the composed channel; default is
\code{'auto'} (same as the first \code{from} channel); other choices
see \code{\link{SIGNAL_TYPES}}}
}
\value{
Nothing
}
\description{
In some cases, for example, deep-brain stimulation ('DBS'),
it is often needed to analyze averaged electrode channels from segmented
'DBS' leads, or create bipolar contrast between electrode channels, or
to generate non-equally weighted channel averages for 'Laplacian' reference.
\code{compose_channel} allows users to generate a phantom channel that does
not physically exist, but is treated as a normal electrode channel in 'RAVE'.
}
\examples{

if(interactive() && has_rave_subject("demo/DemoSubject")) {

  # the actual example code:
  # new channel 100 = 2 x channel 14 - (channe 15 + 16)
  compose_channel(
    subject = "demo/DemoSubject",
    number = 100,
    from = c(14, 15, 16),
    weights = c(2, -1, -1),
    normalize = FALSE
  )

}




}
