% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class007-abstract_electrode.R
\name{RAVEAbstarctElectrode}
\alias{RAVEAbstarctElectrode}
\title{Abstract definition of electrode class in 'RAVE'}
\value{
If \code{simplify} is enabled, and only one block is loaded,
then the result will be a vector (\code{type="voltage"}) or a matrix
(others), otherwise the result will be a named list where the names
are the blocks.
}
\description{
This class is not intended for direct use. Please
create new child classes and implement some key methods.
}
\examples{

if( has_rave_subject("demo/DemoSubject") ) {

# To run this example, please download demo subject (~700 MB) from
# https://github.com/beauchamplab/rave/releases/tag/v0.1.9-beta

generator <- RAVEAbstarctElectrode

# load demo subject electrode 14
e <- generator$new("demo/DemoSubject", number = 14)

# set epoch
e$subject$epoch_names
e$set_epoch("auditory_onset")
head(e$epoch$table)

# set epoch range (-1 to 2 seconds relative to onset)
e$trial_intervals <- c(-1,2)
# or to set multiple ranges
e$trial_intervals <- list(c(-2,-1), c(0, 2))

# set reference
e$subject$reference_names
reference_table <- e$subject$meta_data(
  meta_type = "reference",
  meta_name = "default")
ref_name <- subset(reference_table, Electrode == 14)[["Reference"]]

# the reference is CAR type, mean of electrode 13-16,24
ref_name

# load & set reference
ref <- generator$new(e$subject, ref_name)
e$set_reference(ref)

}
}
\section{Super class}{
\code{\link[ravepipeline:RAVESerializable]{ravepipeline::RAVESerializable}} -> \code{RAVEAbstarctElectrode}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{subject}}{subject instance (\code{\link{RAVESubject}})}

\item{\code{number}}{integer stands for electrode number or reference ID}

\item{\code{reference}}{reference electrode, either \code{NULL} for no reference
or an electrode instance inherits \code{RAVEAbstarctElectrode}}

\item{\code{epoch}}{a \code{\link{RAVEEpoch}} instance}

\item{\code{stitch_events}}{events to stitch, when loading window is not default
to trial onset; must be \code{NULL} or a character vector of length 2}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{type}}{signal type of the electrode, such as 'LFP', 'Spike', and
'EKG'; default is 'Unknown'}

\item{\code{power_enabled}}{whether the electrode can be used in power analyses
such as frequency, or frequency-time analyses;
this usually requires transforming the electrode raw voltage signals
using signal processing methods such as 'Fourier', 'wavelet', 'Hilbert',
'Multitaper', etc.}

\item{\code{is_reference}}{whether this instance is a reference electrode}

\item{\code{location}}{location type of the electrode, see
\code{\link{LOCATION_TYPES}} for details}

\item{\code{exists}}{whether electrode exists in subject}

\item{\code{preprocess_file}}{path to preprocess 'HDF5' file}

\item{\code{power_file}}{path to power 'HDF5' file}

\item{\code{phase_file}}{path to phase 'HDF5' file}

\item{\code{voltage_file}}{path to voltage 'HDF5' file}

\item{\code{reference_name}}{reference electrode name}

\item{\code{epoch_name}}{current epoch name}

\item{\code{cache_root}}{run-time cache path; \code{NA} if epoch or trial
intervals are missing}

\item{\code{trial_intervals}}{trial intervals relative to epoch onset}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RAVEAbstarctElectrode-new}{\code{RAVEAbstarctElectrode$new()}}
\item \href{#method-RAVEAbstarctElectrode-set_reference}{\code{RAVEAbstarctElectrode$set_reference()}}
\item \href{#method-RAVEAbstarctElectrode-set_epoch}{\code{RAVEAbstarctElectrode$set_epoch()}}
\item \href{#method-RAVEAbstarctElectrode-clear_cache}{\code{RAVEAbstarctElectrode$clear_cache()}}
\item \href{#method-RAVEAbstarctElectrode-clear_memory}{\code{RAVEAbstarctElectrode$clear_memory()}}
\item \href{#method-RAVEAbstarctElectrode-load_data_with_epochs}{\code{RAVEAbstarctElectrode$load_data_with_epochs()}}
\item \href{#method-RAVEAbstarctElectrode-load_data}{\code{RAVEAbstarctElectrode$load_data()}}
\item \href{#method-RAVEAbstarctElectrode-load_dimnames_with_epochs}{\code{RAVEAbstarctElectrode$load_dimnames_with_epochs()}}
\item \href{#method-RAVEAbstarctElectrode-load_data_with_blocks}{\code{RAVEAbstarctElectrode$load_data_with_blocks()}}
\item \href{#method-RAVEAbstarctElectrode-load_blocks}{\code{RAVEAbstarctElectrode$load_blocks()}}
\item \href{#method-RAVEAbstarctElectrode-load_dim_with_blocks}{\code{RAVEAbstarctElectrode$load_dim_with_blocks()}}
\item \href{#method-RAVEAbstarctElectrode-clone}{\code{RAVEAbstarctElectrode$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ravepipeline" data-topic="RAVESerializable" data-id="@compare"><a href='../../ravepipeline/html/RAVESerializable.html#method-RAVESerializable-@compare'><code>ravepipeline::RAVESerializable$@compare()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravepipeline" data-topic="RAVESerializable" data-id="@marshal"><a href='../../ravepipeline/html/RAVESerializable.html#method-RAVESerializable-@marshal'><code>ravepipeline::RAVESerializable$@marshal()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravepipeline" data-topic="RAVESerializable" data-id="@unmarshal"><a href='../../ravepipeline/html/RAVESerializable.html#method-RAVESerializable-@unmarshal'><code>ravepipeline::RAVESerializable$@unmarshal()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEAbstarctElectrode-new"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEAbstarctElectrode-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$new(subject, number, quiet = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subject}}{character or \code{\link{RAVESubject}} instance}

\item{\code{number}}{current electrode number or reference ID}

\item{\code{quiet}}{reserved, whether to suppress warning messages}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEAbstarctElectrode-set_reference"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEAbstarctElectrode-set_reference}{}}}
\subsection{Method \code{set_reference()}}{
set reference for instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$set_reference(reference)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reference}}{\code{NULL} or \code{RAVEAbstarctElectrode} instance}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEAbstarctElectrode-set_epoch"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEAbstarctElectrode-set_epoch}{}}}
\subsection{Method \code{set_epoch()}}{
set epoch instance for the electrode
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$set_epoch(epoch, stitch_events = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{epoch}}{characters or \code{\link{RAVEEpoch}} instance. For
characters, make sure \code{"epoch_<name>.csv"} is in meta folder.}

\item{\code{stitch_events}}{events to stitch, default is \code{NULL}, meaning
when loading data, the time is relative to the trial onset (column
\code{"Time"} in the epoch file); set to a character of length 2,
representing the events if time is not relative to trial onset. Please
remove the prefix. For example, for a column named \code{"Event_name"},
the event name is \code{"name"}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEAbstarctElectrode-clear_cache"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEAbstarctElectrode-clear_cache}{}}}
\subsection{Method \code{clear_cache()}}{
method to clear cache on hard drive
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$clear_cache(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{implemented by child instances}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEAbstarctElectrode-clear_memory"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEAbstarctElectrode-clear_memory}{}}}
\subsection{Method \code{clear_memory()}}{
method to clear memory
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$clear_memory(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{implemented by child instances}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEAbstarctElectrode-load_data_with_epochs"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEAbstarctElectrode-load_data_with_epochs}{}}}
\subsection{Method \code{load_data_with_epochs()}}{
method to load electrode data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$load_data_with_epochs(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{data type such as \code{"power"}, \code{"phase"},
\code{"voltage"}, \code{"wavelet-coefficient"}, or others
depending on child class implementations}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEAbstarctElectrode-load_data"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEAbstarctElectrode-load_data}{}}}
\subsection{Method \code{load_data()}}{
alias of \code{load_data_with_epochs} for legacy code
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$load_data(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{see \code{load_data_with_epochs}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEAbstarctElectrode-load_dimnames_with_epochs"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEAbstarctElectrode-load_dimnames_with_epochs}{}}}
\subsection{Method \code{load_dimnames_with_epochs()}}{
get expected dimension names
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$load_dimnames_with_epochs(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{see \code{load_data_with_epochs}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEAbstarctElectrode-load_data_with_blocks"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEAbstarctElectrode-load_data_with_blocks}{}}}
\subsection{Method \code{load_data_with_blocks()}}{
load electrode block-wise data (with reference),
useful when epoch is absent
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$load_data_with_blocks(blocks, type, simplify = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{blocks}}{session blocks}

\item{\code{type}}{data type such as \code{"power"}, \code{"phase"},
\code{"voltage"}, \code{"wavelet-coefficient"}.}

\item{\code{simplify}}{whether to simplify the result}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEAbstarctElectrode-load_blocks"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEAbstarctElectrode-load_blocks}{}}}
\subsection{Method \code{load_blocks()}}{
alias of \code{load_data_with_blocks} for legacy code
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$load_blocks(blocks, type, simplify = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{blocks, type, simplify}}{see \code{load_data_with_blocks}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEAbstarctElectrode-load_dim_with_blocks"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEAbstarctElectrode-load_dim_with_blocks}{}}}
\subsection{Method \code{load_dim_with_blocks()}}{
get expected dimension information for block-based loader
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$load_dim_with_blocks(blocks, type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{blocks, type}}{see \code{load_data_with_blocks}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEAbstarctElectrode-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEAbstarctElectrode-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEAbstarctElectrode$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
