% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.r
\name{as.data.frame.rdt}
\alias{as.data.frame.rdt}
\alias{as.data.frame.srt}
\alias{as.data.frame.rdpmedian}
\alias{as.data.frame.pmedian}
\title{Coerce to a data frame}
\usage{
\method{as.data.frame}{rdt}(x, ...)

\method{as.data.frame}{srt}(x, ...)

\method{as.data.frame}{rdpmedian}(x, ...)

\method{as.data.frame}{pmedian}(x, ...)
}
\arguments{
\item{x}{Objects returned by:
\itemize{
\item \code{\link[=rdt]{rdt()}} or \code{\link[=rdt2]{rdt2()}}
\item \code{\link[=srt]{srt()}} or \code{\link[=srt2]{srt2()}}
\item \code{\link[=rdpmedian]{rdpmedian()}} or \code{\link[=rdpmedian2]{rdpmedian2()}}
\item \code{\link[=pmedian]{pmedian()}} or \code{\link[=pmedian2]{pmedian2()}}
}}

\item{...}{Unused arguments.}
}
\value{
\code{data.frame}
}
\description{
Coerce objects to a \code{data.frame} in the style of \code{broom::tidy()}.
}
\examples{
#----------------------------------------------------------------------------
# as.data.frame() examples
#----------------------------------------------------------------------------
library(rankdifferencetest)

# Use example data from Kornbrot (1990)
data <- kornbrot_table1

rdt(
  data = data,
  formula = placebo ~ drug,
  conf_level = 0.95,
  alternative = "two.sided",
  distribution = "asymptotic",
  zero_method = "wilcoxon",
  correct = FALSE
) |>
  as.data.frame()

rdpmedian(
  data = data,
  formula = placebo ~ drug,
  conf_level = 0.95
) |>
  as.data.frame()

}
