% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_by_priority.R
\name{rank_by_priority}
\alias{rank_by_priority}
\title{Rank a character vector based on supplied priority values}
\usage{
rank_by_priority(x, priority_values, ties.method = "average")
}
\arguments{
\item{x}{A character vector.}

\item{priority_values}{A character vector descibing "priority" values.  Elements of \code{x} matching
\code{priority_values} will be ranked based on their order of appearance in \code{priority_values}}

\item{ties.method}{a character string specifying how ties are treated,
    see \sQuote{Details}; can be abbreviated.}
}
\value{
A vector of ranks describing \code{x} such that \code{x[order(ranks)]}
will move \code{priority_values} to the front of the vector
}
\description{
Rank a character vector based on supplied priority values
}
\examples{
x <- c("A", "B", "C", "D", "E")
rank_by_priority(x, c("C", "A"))
#> "2" "4" "1" "4" "4"

rank_by_priority(1:6, c(4, 2, 7))
#>  4 2 1 3 5 6

}
