% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.sim_data.R
\name{print.sim_data}
\alias{print.sim_data}
\title{Print \code{sim_data} Object}
\usage{
\method{print}{sim_data}(x, ...)
}
\arguments{
\item{x}{\code{sim_data} object; returned by the \code{\link{initialise}} function}

\item{...}{further arguments passed to or from other methods;
currently none specified}
}
\value{
\code{sim_data} object is invisibly returned (the \code{x} param)
}
\description{
Print \code{sim_data} Object
}
\examples{

library(terra)

n1_small <- rast(system.file("input_maps/n1_small.tif", package = "rangr"))
K_small <- rast(system.file("input_maps/K_small.tif", package = "rangr"))

sim_data <- initialise(
  n1_map = n1_small,
  K_map = K_small,
  r = log(2),
  rate = 1 / 1e3
)
print(sim_data)

}
