% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hvl.R
\name{hvl}
\alias{hvl}
\title{half-value layer and tenth-value layer computations}
\usage{
hvl(x, y)
}
\arguments{
\item{x}{material thickness}

\item{y}{radiation measure through the material}
}
\value{
a data frame with the inputs, followed by the computed values for attenuation coefficient (listed as "mu"), half-value layer (hvl), tenth-value layer (tvl), and the homogeneity coefficient (hc) which is the ratio of a half-value layer to the following half-value layer.
}
\description{
Derive hvl and tvl from radiation values through a material thickness.
}
\examples{
H50_ex <- data.frame("mm_Al" = 0:5, "mR_h" = c(7.428, 6.272, 5.325,4.535, 3.878, 3.317))
hvl(x = H50_ex$mm_Al, y = H50_ex$mR_h) 
}
