% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piped.R
\name{rotate}
\alias{rotate}
\title{Rotate ENA Data}
\usage{
rotate(x, ..., wh = ena.rotate.by.generalized)
}
\arguments{
\item{x}{An \code{ena.set} object to be rotated.}

\item{...}{Optional formulas or additional arguments for rotation.}

\item{wh}{Function to use for rotation (default: \code{ena.svd}).}
}
\value{
The rotated \code{ena.set} object with updated rotation matrices.
}
\description{
Rotates ENA data using a specified rotation function (default: SVD), optionally using formulas or grouping variables.
}
\examples{
# Assuming 'set' is an ena.set object:
data(RS.data)

codes <- c("Data", "Technical.Constraints", "Performance.Parameters",
           "Client.and.Consultant.Requests", "Design.Reasoning",
           "Collaboration")
units <- c("Condition", "UserName")
horizon <- c("Condition", "GroupName")
enaset <- RS.data |>
  accumulate(units, codes, horizon) |>
  sphere_norm() |>
  center() |>
  rotate()
}
