% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piped.R
\name{optimize}
\alias{optimize}
\title{Optimize Node and Centroid Positions in ENA Set}
\usage{
optimize(x, weights = NULL)
}
\arguments{
\item{x}{An \code{ena.set} object for which to optimize node and centroid positions.}

\item{weights}{Optional. A numeric matrix of connection weights. If provided, the function will use this matrix instead of the connection counts from the \code{ena.set}.}
}
\value{
The input \code{ena.set} object with updated node and centroid positions.
}
\description{
This function computes and assigns node positions and centroids for an ENA set object
using the current points and rotation information.
}
\examples{
# Assuming 'set' is an ena.set object:
data(RS.data)

codes <- c("Data", "Technical.Constraints", "Performance.Parameters",
           "Client.and.Consultant.Requests", "Design.Reasoning",
           "Collaboration")
units <- c("Condition", "UserName")
horizon <- c("Condition", "GroupName")
enaset <- RS.data |>
  accumulate(units, codes, horizon) |>
  sphere_norm() |>
  center() |>
  rotate() |>
  project() |>
  optimize()
}
