% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.plot.R
\name{group}
\alias{group}
\title{Add all groups to an ENA plot}
\usage{
group(x, wh = NULL)
}
\arguments{
\item{x}{An `ENAplot` object (as returned by `plot.ena.set`).}

\item{wh}{(Ignored) Included for compatibility with other plotting functions.}
}
\value{
The modified `ENAplot` object with all groups added as points.
}
\description{
This function iterates over all unique values of the first metadata column (excluding 'QEUNIT' and 'ENA_UNIT')
in the ENA set and adds each group as a set of points to the ENA plot. This is useful for quickly visualizing
all groups in a categorical variable on the same plot.
}
\details{
The function finds the first metadata column in the ENA set (excluding 'QEUNIT' and 'ENA_UNIT'),
and for each unique value in that column, calls `add_points()` to add the group's points to the plot.
}
\examples{
# Load test data
data(RS.data);

# Define codenames for the test
codenames <- c("Data", "Technical.Constraints", "Performance.Parameters",
  "Client.and.Consultant.Requests", "Design.Reasoning", "Collaboration");

# Standard ENA accumulation
accum <- rENA:::ena.accumulate.data.file(
  RS.data, units.by = c("UserName", "Condition"),
  conversations.by = c("ActivityNumber", "GroupName"),
  codes = codenames
);
# Create a standard ENA set 
newset <- ena.make.set(accum);

# Simple plot for a set of points, and their mean
newplot <- plot(newset) |> 
  add_points(Condition$FirstGame, mean = TRUE, colors = "blue") |> 
  add_network();

# Plot a single unit's point and it's line.weights
plot(newset) |> 
  add_points(UserName$`steven z`) |> 
  add_network();

# Trajectory accumulation and plotting
trajectory_accumulation <- rENA:::ena.accumulate.data.file(
  RS.data, units.by = c("UserName", "Condition"),
  conversations.by = c("ActivityNumber", "GroupName"),
  codes = codenames,
  model = "A"
);
trajectory_model <- ena.make.set(trajectory_accumulation);

newplot3 <- plot(trajectory_model) |> 
  add_trajectory(Condition$FirstGame);
}
