% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_visualisation.R
\name{visualise_prior}
\alias{visualise_prior}
\title{Visualise Prior Distributions}
\usage{
visualise_prior(
  prior,
  parameter = NULL,
  xlim = NULL,
  add_reference = TRUE,
  samples = 10000
)
}
\arguments{
\item{prior}{Prior specification in qbrms format, or a list of prior
specifications to compare}

\item{parameter}{Character string specifying which parameter to visualise
(e.g., "b", "sd", "sigma"). If NULL, visualises all priors.}

\item{xlim}{Numeric vector of length 2 specifying x-axis limits. If NULL,
automatically determined.}

\item{add_reference}{Logical; if TRUE, adds reference distributions for
comparison (default: TRUE)}

\item{samples}{Number of samples to draw for visualisation (default: 10000)}
}
\value{
A ggplot object showing the prior distribution(s)
}
\description{
Create visual representations of prior distributions to aid in prior
specification and sensitivity analysis.
}
\details{
This function helps users:
\itemize{
\item Visualise the implications of their prior choices
\item Compare different prior specifications
\item Identify overly informative or vague priors
\item Understand prior-data conflict potential
}

Supported prior distributions include:
\itemize{
\item Normal: normal(mean, sd)
\item Student t: student_t(df, mean, scale)
\item Cauchy: cauchy(location, scale)
\item Exponential: exponential(rate)
\item Gamma: gamma(shape, rate)
\item Uniform: uniform(lower, upper)
}
}
\examples{
\dontrun{
# Visualise a single prior
prior <- prior(normal(0, 10), class = "b")
visualise_prior(prior)

# Compare different priors
prior_list <- list(
  "Weak" = prior(normal(0, 10), class = "b"),
  "Medium" = prior(normal(0, 5), class = "b"),
  "Strong" = prior(normal(0, 1), class = "b")
)
visualise_prior(prior_list)

# Visualise with custom limits
visualise_prior(prior, xlim = c(-20, 20))
}

}
