% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prior_Posterior_Comparison.R, R/prior_checks.R
\name{plot_parameters}
\alias{plot_parameters}
\title{Plot Parameters with Prior/Posterior Comparison}
\usage{
plot_parameters(
  object,
  pars = NULL,
  show_prior = FALSE,
  ndraws = 200,
  prior_ndraws = 200,
  ncol = 2,
  alpha_levels = c(0.8, 0.5),
  colours = c("#1F78B4", "#E31A1C"),
  verbose = TRUE,
  ...
)

plot_parameters(
  object,
  pars = NULL,
  show_prior = FALSE,
  ndraws = 200,
  prior_ndraws = 200,
  ncol = 2,
  alpha_levels = c(0.8, 0.5),
  colours = c("#1F78B4", "#E31A1C"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A \code{qbrms_fit} object.}

\item{pars}{Optional character vector of parameter names to plot. If \code{NULL},
plots all fixed-effect parameters.}

\item{show_prior}{Logical; if \code{TRUE}, overlay prior distributions.}

\item{ndraws}{Number of posterior draws to use for plotting.}

\item{prior_ndraws}{Number of prior draws to use if \code{show_prior = TRUE}.}

\item{ncol}{Number of columns for faceting (default 2).}

\item{alpha_levels}{Numeric vector of length 2 giving alpha levels for
c(posterior, prior). Default c(0.8, 0.5).}

\item{colours}{Character vector of length 2 giving colours for
c(posterior, prior). Default c("#1F78B4", "#E31A1C").}

\item{verbose}{Logical; print progress information.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A ggplot2 object with faceted parameter density plots.

A ggplot2 object with faceted parameter density plots.
}
\description{
Create density plots for multiple model parameters, optionally comparing
posterior estimates with their priors. Returns a ggplot2 object with
faceted parameter plots.

Create density plots for multiple model parameters, optionally comparing
posterior estimates with their priors. Returns a ggplot2 object with
faceted parameter plots.
}
\examples{
\dontrun{
fit <- qbrms(y ~ x1 + x2, data = my_data, sample_prior = "yes")

# Plot all parameters
plot_parameters(fit)

# Plot specific parameters with priors
plot_parameters(fit, pars = c("x1", "x2"), show_prior = TRUE)

# Customize appearance
plot_parameters(fit, show_prior = TRUE) + 
  theme_bw() + 
  labs(title = "My Parameter Estimates")
}
\dontrun{
fit <- qbrms(y ~ x1 + x2, data = my_data, sample_prior = "yes")

# Plot all parameters
plot_parameters(fit)

# Plot specific parameters with priors
plot_parameters(fit, pars = c("x1", "x2"), show_prior = TRUE)

# Customize appearance
plot_parameters(fit, show_prior = TRUE) + 
  theme_bw() + 
  labs(title = "My Parameter Estimates")
}
}
