% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.r
\name{compare_discounting}
\alias{compare_discounting}
\title{Compare Multiple Discounting Parameters}
\usage{
compare_discounting(
  historical_data,
  current_data,
  a0_values = seq(0, 1, by = 0.1),
  multivariate = FALSE,
  n_samples = 1000,
  ...
)
}
\arguments{
\item{historical_data}{Historical data (vector for univariate, matrix for multivariate)}

\item{current_data}{Current data (vector for univariate, matrix for multivariate)}

\item{a0_values}{Vector of discounting parameters to compare}

\item{multivariate}{Logical indicating if data is multivariate (default: FALSE)}

\item{n_samples}{Number of posterior samples per a0 value (default: 1000)}

\item{...}{Additional arguments passed to powerprior functions}
}
\value{
A data frame with summary statistics for each a0 value
}
\description{
Computes posteriors for multiple values of a0 to facilitate sensitivity analysis.
}
\examples{
set.seed(123)
historical <- rnorm(50, mean = 10, sd = 2)
current <- rnorm(30, mean = 10.5, sd = 2)

comparison <- compare_discounting(
  historical,
  current,
  a0_values = c(0, 0.25, 0.5, 0.75, 1.0)
)
print(comparison)

}
