% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision-helpers.R
\name{decide_sample_size}
\alias{decide_sample_size}
\title{Decide recommended sample size from power/assurance results}
\usage{
decide_sample_size(
  x,
  direction = NULL,
  threshold = NULL,
  rope_in = NULL,
  bf10 = NULL,
  bf_prop_min = 0,
  targets = NULL
)
}
\arguments{
\item{x}{A list with \verb{$summary} (engine output) or a data.frame summary itself.}

\item{direction}{Numeric in \eqn{[0, 1]}, required power for \code{power_direction} (optional).}

\item{threshold}{Numeric in \eqn{[0, 1]}, required power for \code{power_threshold} (optional).}

\item{rope_in}{Numeric in \eqn{[0, 1]}, maximum allowed Pr(in ROPE) (optional).
Note: since summaries usually contain \verb{power_rope = Pr(outside ROPE) >= prob_threshold},
we compare \code{(1 - power_rope) <= rope_in} when \code{rope_in} is given.}

\item{bf10}{Numeric Bayes-factor cutoff (e.g., 10). If provided, we look for a column
named \verb{bf_hit_<bf10>}; if not found, we fall back to any \verb{bf_hit_*} column present.}

\item{bf_prop_min}{Numeric in \eqn{[0, 1]}, the minimum proportion of simulations that must
achieve BF >= \code{bf10} (default 0).}

\item{targets}{Optional list alternative to the direct args. Ignored if any direct arg
is non-NULL.}
}
\value{
A data.frame with recommended n per effect combination and the rationale.
}
\description{
Returns the smallest n per effect setting that meets user-specified targets.
Works with both brms_inla_power() and brms_inla_power_sequential() outputs.
}
\details{
You can pass targets directly via arguments (direction, threshold, rope_in, bf10)
or via \code{targets = list(direction=..., threshold=..., rope_in=..., bf10=...)}.
Direct arguments take precedence if supplied.
}
