% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_transformers.R
\name{tt_tbl_dims}
\alias{tt_tbl_dims}
\title{Table Transformer: get the dimensions of a table}
\usage{
tt_tbl_dims(tbl)
}
\arguments{
\item{tbl}{\emph{A data table}

\verb{obj:<tbl_*>} // \strong{required}

A table object to be used as input for the transformation. This can be a
data frame, a tibble, a \code{tbl_dbi} object, or a \code{tbl_spark} object.}
}
\value{
A \code{tibble} object.
}
\description{
With any table object, you can produce a summary table that contains nothing
more than the table's dimensions: the number of rows and the number of
columns. The output summary table will have two columns and two rows. The
first is the \code{".param."} column with the labels \code{"rows"} and \code{"columns"}; the
second column, \code{"value"}, contains the row and column counts.
}
\section{Examples}{


Get the dimensions of the \code{game_revenue} dataset that is included in the
\strong{pointblank} package.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tt_tbl_dims(tbl = game_revenue)
#> # A tibble: 2 x 2
#>   .param. value
#>   <chr>   <int>
#> 1 rows     2000
#> 2 columns    11
}\if{html}{\out{</div>}}

This output table is useful when a table validation depends on its
dimensions. Here, we check that \code{game_revenue} has at least \code{1500} rows.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tt_tbl_dims(tbl = game_revenue) \%>\%
  dplyr::filter(.param. == "rows") \%>\%
  test_col_vals_gt(
    columns = value,
    value = 1500
  )
#> [1] TRUE
}\if{html}{\out{</div>}}

We can check \code{small_table} to ensure that number of columns is less than
\code{10}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tt_tbl_dims(tbl = small_table) \%>\%
  dplyr::filter(.param. == "columns") \%>\%
  test_col_vals_lt(
    columns = value,
    value = 10
  )
#> [1] TRUE
}\if{html}{\out{</div>}}
}

\section{Function ID}{

12-3
}

\seealso{
Other Table Transformers: 
\code{\link{get_tt_param}()},
\code{\link{tt_string_info}()},
\code{\link{tt_summary_stats}()},
\code{\link{tt_tbl_colnames}()},
\code{\link{tt_time_shift}()},
\code{\link{tt_time_slice}()}
}
\concept{Table Transformers}
