% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_converters.R
\name{nn_converter_nlmixr}
\alias{nn_converter_nlmixr}
\title{NN converter for nlmixr}
\usage{
nn_converter_nlmixr(
  f_ode,
  pop_only = FALSE,
  theta_scale = 0.1,
  eta_scale = 0.1,
  pre_fixef = NULL,
  seed = 1908
)
}
\arguments{
\item{f_ode}{(nlmixr model function) Model function of nlmixr type with NN functions}

\item{pop_only}{(boolean) If the generated nlmixr model function should be a fit without (TRUE) or with (FALSE)
inter-individual variability on NN parameters}

\item{theta_scale}{(numeric) Scale in which typical NN parameter values are initialized, default is 0.1, i.e., weights are 
initialized between -0.3 and 0.3}

\item{eta_scale}{(numeric) Initial standard deviation of random effects on NN parameters, default is 0.1}

\item{pre_fixef}{(named vector) Specific initial values for typical parameters, can be obtained from a run nlmixr model (e.g., run_1) through
\emph{run_1$fixef}}

\item{seed}{(numeric) Seed for random parameter initialization.}
}
\value{
A converted nlmixr model function
}
\description{
This function converts a nlmixr model function that includes pseudo-functions for NNs as described in \strong{Details}
into a model function that can be used in the \emph{nlmixr} function.
}
\details{
\itemize{
  \item \emph{state=} defines the state to be used in the NN. For time, use \emph{t}.
  \item \emph{min_init=} defines the minimal activation point for the NN, i.e., minimal expected state
  \item \emph{max_init=} defines the maximal activation point for the NN, i.e., maximal expected state
  \item \emph{n_hidden=} (optional) defines the number of neurons in the hidden layer, default is 5
  \item \emph{act=} (optional) defines activation function in the hidden layer, ReLU and Softplus implemented, default is ReLU
  \item \emph{time_nn=} (optional) defines whether the NN should be assumed to be a time-dependent NN
    and consequently all weights from input to hidden layer should be strictly negative.
}
}
\examples{
\dontrun{
f_ode_pop <- function(){
ini({
  lV <- 1
  prop.err <- 0.1
})
model({
  V <- lV
  d/dt(centr)  =  NN1(state=centr,min_init=0,max_init=300)
  cp = centr / V
  cp ~ prop(prop.err)
  })
}

f_new_pop <- nn_converter_nlmixr(f_ode_pop,pop_only = TRUE)

fit_pop <- nlmixr2(f_new_pop,data,est="bobyqa")

f_ode <- function(){
  ini({
    lV <- 1
    eta.V ~ 0.1
    prop.err <- 0.1
  })
  model({
    V <- lV * exp(eta.V)
    d/dt(centr)  =  NN1(state=centr,min_init=0,max_init=300)
    cp = centr / V
    cp ~ prop(prop.err)
  })
}

f_new <- nn_converter_nlmixr(f_ode,pop_only = FALSE, pre_fixef = fit_pop$fixef)
}
}
\author{
Dominic Bräm
}
