% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_nm.R
\name{indparm_extractor_nm}
\alias{indparm_extractor_nm}
\title{NONMEM individual estimations extractor}
\usage{
indparm_extractor_nm(res_file, phi_file)
}
\arguments{
\item{res_file}{(Path/)Name of the results file of a NONMEM run, must include file extension, e.g., \dQuote{.res}}

\item{phi_file}{(Path/)Name of the phi file of a NONMEM run, must include file extension, e.g., \dQuote{.phi}}
}
\value{
Data frame with individual parameter estimates for NN parameters
}
\description{
When the NOMEM model has been run, this function allows to extract the
estimated individual parameters for NN parameters by combining information from the .res and
the .phi file
}
\examples{
res_path <- system.file("extdata","nm_example1_model_converted_ind.res",package="pmxNODE")
phi_path <- system.file("extdata","nm_example1_model_converted_ind.phi",package="pmxNODE")
est_parms <- indparm_extractor_nm(res_path,phi_path)
}
\author{
Dominic Bräm
}
