% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/der_vs_state.R
\name{derivative_calc_mlx}
\alias{derivative_calc_mlx}
\title{Internal: Calculate the derivatives from a NN in Monolix}
\usage{
derivative_calc_mlx(
  nn_name,
  parms,
  inputs,
  n_hidden = 5,
  time_nn = FALSE,
  act = "ReLU",
  beta = 20
)
}
\arguments{
\item{nn_name}{(string) Name of the NN, e.g., \dQuote{c} for NNc(...)}

\item{parms}{(named vector) Named vector of estimated parameters from the NN; Namings are e.g. Wc_11 for the weight from input to the first hidden unit of NN called "c"}

\item{inputs}{(vector) Vector cointain the state values for which the derivatives should be calculated}

\item{n_hidden}{(numeric) Number of neurons in the hidden layer, default value is 5}

\item{time_nn}{(boolean) Whether the NN is a time-dependent NN and negative weights should be applied from input to hidden layer. Default values is FALSE.}

\item{act}{(string) Activation function used in the NN. Currently "ReLU" and "Softplus" available.}

\item{beta}{(numeric) Beta value for the Softplus activation function, only applicable if \emph{act="Softplus"}; Default to 20.}
}
\value{
A vector of derivatives of the NN for the state values
}
\description{
Calculate the derivatives from a NN for derivative versus state plots
}
\author{
Dominic Bräm
}
\keyword{internal}
