% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pruning_pleioh2g_wrapper.R
\name{pruning_pleioh2g_wrapper}
\alias{pruning_pleioh2g_wrapper}
\title{Perform pruning in computing pleioh2g and correct bias}
\usage{
pruning_pleioh2g_wrapper(
  G,
  phenotype,
  munged_sumstats,
  ld_path,
  wld_path,
  sample_prev = NULL,
  population_prev = NULL,
  n_block = 200,
  hmp3,
  sample_rep
)
}
\arguments{
\item{G}{index of target disease.}

\item{phenotype}{Vector of the phenotype name}

\item{munged_sumstats}{All LDSC-munged GWAS .stat.gz}

\item{ld_path}{Path to directory containing ld score files.}

\item{wld_path}{Path to directory containing weight files.}

\item{sample_prev}{Vector of sample prevalence, in the same order of input GWAS summary statistics.}

\item{population_prev}{Vector of population prevalence, in the same order of input GWAS summary statistics.}

\item{n_block}{number of jackknife blocks.}

\item{hmp3}{Directory for hapmap 3 snplist.}

\item{sample_rep}{sampling times in bias correction}
}
\value{
A `list` containing the following elements:
  - `target_disease` (character): The value "401.1".
  - `target_disease_h2_est` (numeric): target disease h2g.
  - `target_disease_h2_se` (numeric): target disease h2g_se.
  - `selected_auxD` (character): auxiliary diseases.
  - `h2pleio_uncorr` (numeric): pre-correction pleiotropic heritability estimate.
  - `h2pleio_uncorr_se` (numeric): pre-correction pleiotropic heritability jackknife s.e. estimate.
  - `percentage_h2pleio_uncorr` (numeric): pre-correction percentage of pleiotropic heritability estimate.
  - `percentage_h2pleio_uncorr_se` (numeric): pre-correction percentage of pleiotropic heritability jackknife s.e. estimate.
  - `percentage_h2pleio_uncorr_jackknife` (numeric): vector of all pre-correction percentage of pleiotropic heritability jackknife estimates.
  - `h2pleio_corr` (numeric): post-correction pleiotropic heritability estimate.
  - `h2pleio_corr_se` (numeric): post-correction pleiotropic heritability jackknife s.e. estimate.
  - `percentage_h2pleio_corr` (numeric): post-correction percentage of pleiotropic heritability estimate.
  - `percentage_h2pleio_corr_se` (numeric): post-correction percentage of pleiotropic heritability jackknife s.e. estimate.
  - `corrected_weight` (numeric): corrected weight in bias correction.
}
\description{
Perform pruning in computing pleioh2g and correct bias
}
