% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_piece.R
\name{geom_piece}
\alias{geom_piece}
\alias{aes_piece}
\title{Draw board game pieces with ggplot2}
\usage{
geom_piece(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  envir = getOption("piecepackr.envir", piecepackr::game_systems()),
  op_scale = getOption("piecepackr.op_scale", 0),
  op_angle = getOption("piecepackr.op_angle", 45),
  inherit.aes = TRUE
)

aes_piece(df)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used to override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Aesthetics, used to set an aesthetic to a fixed value.}

\item{envir}{Environment (or named list) containing configuration list(s).}

\item{op_scale}{How much to scale the depth of the piece in the oblique projection
(viewed from the top of the board).
\code{0} (the default) leads to an \dQuote{orthographic} projection,
\code{0.5} is the most common scale used in the \dQuote{cabinet} projection,
and \code{1.0} is the scale used in the \dQuote{cavalier} projection.}

\item{op_angle}{What is the angle of the oblique projection?  Has no effect if \code{op_scale} is \code{0}.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}

\item{df}{A data frame of game piece information with (at least) the
named columns \dQuote{piece_side}, \dQuote{x}, and \dQuote{y}.}
}
\description{
\code{geom_piece()} creates a \code{ggplot2} geom.
\code{aes_piece()} takes a data frame and generates
an appropriate \code{ggplot2::aes()} mapping.
}
\details{
\code{geom_piece()} requires a fixed scale coordinate system with an aspect
ratio of 1 as provided by \code{ggplot2::coord_fixed()}.
\code{geom_piece()} also requires that \code{cfg} is a character vector (and not a \code{pp_cfg()} object).
In particular if using \code{op_transform()} one should set its argument \code{cfg_class = "character"}
if intending for use with \code{geom_piece()}.
}
\section{Aesthetics}{

\code{geom_piece()} understands the following aesthetics (required aesthetics are in bold).
See \code{\link[=pieceGrob]{pieceGrob()}} for more details.
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \code{z}
\item \code{piece_side}
\item \code{rank}
\item \code{suit}
\item \code{cfg}
\item \code{width}
\item \code{height}
\item \code{depth}
\item \code{angle}
\item \code{scale}
\item \code{type}
}
}

\examples{
if (require("ggplot2", quietly = TRUE) && require("tibble", quietly = TRUE)) {
  envir <- game_systems("sans")
  df_board <- tibble(piece_side = "board_face", suit = 3, rank = 8,
                 x = 4.5, y = 4.5)
  df_w <- tibble(piece_side = "bit_back", suit = 6, rank = 1,
                 x = rep(1:8, 2), y = rep(1:2, each=8))
  df_b <- tibble(piece_side = "bit_back", suit = 1, rank = 1,
                 x = rep(1:8, 2), y = rep(7:8, each=8))
  df <- rbind(df_board, df_w, df_b)
  # 2D example
  # `cfg` must be a character vector for `geom_piece()`
  ggplot(df, aes_piece(df)) +
      geom_piece(cfg = "checkers1", envir = envir) +
      coord_fixed() +
      scale_x_piece() +
      scale_y_piece() +
      theme_minimal(28) +
      theme(panel.grid = element_blank())
}
if (require("ggplot2", quietly = TRUE) && require("tibble", quietly = TRUE)) {
  # 3D "oblique" projection example
  # `cfg_class` must be "character" when using with `geom_piece()`
  df3d <- op_transform(df, cfg = "checkers1", envir = envir,
                       op_angle = 45, cfg_class = "character")
  ggplot(df3d, aes_piece(df3d)) +
      geom_piece(cfg = "checkers1", envir = envir,
                 op_angle = 45, op_scale = 0.5) +
      coord_fixed() +
      theme_void()
}
}
\seealso{
\code{geom_piece()} is a wrapper around \code{\link[=pieceGrob]{pieceGrob()}}.
\code{\link[=scale_x_piece]{scale_x_piece()}} and \code{\link[=scale_y_piece]{scale_y_piece()}} are wrappers
around \code{\link[ggplot2:scale_continuous]{ggplot2::scale_x_continuous()}} and \code{\link[ggplot2:scale_continuous]{ggplot2::scale_y_continuous()}}
with better defaults for board game diagrams.
}
