% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcoicop.R
\name{get_pcoicop}
\alias{get_pcoicop}
\title{Philippine Classification of Individual Consumption According to Purpose (PCOICOP)}
\usage{
get_pcoicop(
  ...,
  token = NULL,
  version = NULL,
  level = NULL,
  harmonize = TRUE,
  minimal = TRUE,
  cols = NULL
)
}
\arguments{
\item{...}{See \code{?dplyr::filter}. Expressions that return a logical value, and are defined in terms of the variables in returned data. If multiple expressions are included, they are combined with the & operator. Only rows for which all conditions evaluate to TRUE are kept.}

\item{token}{Character. API access token.}

\item{version}{Character. Version of the PCOICOP to retrieve. Default is \code{NULL}. If \code{NULL}, the latest version is used.}

\item{level}{Character. Level of detail to retrieve. Options are \code{"all"}, \code{"divisions"}, \code{"groups"}, \code{"class"}, \code{"sub-class"}, \code{"item"}, and \code{"subitem"}.}

\item{harmonize}{Logical. If \code{TRUE}, formats and standardizes the returned data. Default is \code{TRUE}.}

\item{minimal}{Logical. If \code{TRUE}, returns a simplified dataset. Default is \code{TRUE}.}

\item{cols}{Optional. Character vector of additional columns to include when \code{minimal = FALSE}.}
}
\value{
A tibble containing the requested PCOICOP data.
}
\description{
Philippine Classification of Individual Consumption According to Purpose (PCOICOP)
}
\examples{
\dontrun{
get_pcoicop(token = "your_api_token")
}
# If token is not provided, the function will fetch from local cache or
# download the latest version from remote repo
pcoicop <- get_pcoicop()

# Get specific level
pcoicop_filtered <- get_pcoicop(level = "divisions")
pcoicop_filtered
}
\references{
\url{https://psa.gov.ph/classification/pcoicop}
}
