% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partialling_out.R
\name{partialling_out}
\alias{partialling_out}
\title{partialling_out: partialling out variable of interest and main}
\usage{
partialling_out(model, data, weights, both, na.rm, ...)
}
\arguments{
\item{model}{object for which we want to residualise variables}

\item{data}{data.frame used in the original model. Using different data will
return unexpected results or an error.}

\item{weights}{a numeric vector for weighting the partial models. Length must be
equal to number of rows of \code{data}}

\item{both}{if \code{TRUE} will residualise both the variable of interest and the
first explanatory variable in the model. If \code{FALSE}, only the latter.
Set to \code{TRUE} by default}

\item{na.rm}{if \code{TRUE} will remove observations with NA before any models are
run. If \code{FALSE}, the underlying \code{lm}, \code{feols}, or \code{felm} will remove NA
values but errors may arise if weights are used.}

\item{...}{Any other lm, feols, or felm parameters that will be passed to the
partial regressions}
}
\value{
a data.frame with the (residualised) variable of interest and
residualised main explanatory variable
}
\description{
Creates a data.frame of the residualised main explanatory variable and,
if wanted, variable of interest of a linear or fixed effects model
}
\details{
The function regresses the main (i.e. first in the model) explanatory
variable and the variable of interest (if parameter \code{both} is set to \code{TRUE})
against all other control variables and fixed effects and returns the
residuals in a data.frame

Will accept lm, felm (lfe package), and feols (fixest package) objects
}
\examples{
\donttest{library(palmerpenguins)
library(fixest)
model <- feols(bill_length_mm ~ bill_depth_mm | species + island,
               data = penguins)
partial_df <- partialling_out(model, penguins, both = TRUE)
}
}
