% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_parquet_at_once.R
\name{write_parquet_at_once}
\alias{write_parquet_at_once}
\title{write parquet file or dataset based on partition argument \cr}
\usage{
write_parquet_at_once(
  data,
  path_to_parquet,
  partition = "no",
  compression = "snappy",
  compression_level = NULL,
  ...
)
}
\arguments{
\item{data}{the data.frame/tibble to write}

\item{path_to_parquet}{String that indicates the path to the directory where
the output parquet file or dataset will be stored.}

\item{partition}{string ("yes" or "no" - by default) that indicates whether you want to create a partitioned parquet file.
If "yes", \code{"partitioning"} argument must be filled in. In this case, a folder will be created for each modality of the variable filled in \code{"partitioning"}.}

\item{compression}{compression algorithm. Default "snappy".}

\item{compression_level}{compression level. Meaning depends on compression algorithm.}

\item{...}{Additional format-specific arguments,  see
\href{https://arrow.apache.org/docs/r/reference/write_parquet.html}{arrow::write_parquet()}}
}
\value{
a dataset as return by arrow::open_dataset
}
\description{
Low level function that implements the logic to write a parquet file or a dataset from data
}
\examples{

write_parquet_at_once(iris, tempfile())

write_parquet_at_once(iris, tempfile(), partition = "yes", partitioning = c("Species"))

\dontrun{
write_parquet_at_once(iris, tempfile(), compression="gzip", compression_level = 5)
}
}
