% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{makePlots}
\alias{makePlots}
\title{Generate a specified plot outside the GUI}
\usage{
makePlots(
  space1,
  settings,
  cov = NULL,
  covInv = NULL,
  exp = NULL,
  space2 = NULL,
  space2.cov = NULL,
  space2.covInv,
  space2.exp = NULL,
  user_dist = NULL,
  getCoordsSpace1 = normCoords,
  getCoordsSpace2 = normCoords,
  getScore = NULL
)
}
\arguments{
\item{space1}{dataframe of variables in cluster space}

\item{settings}{list specifying parameters usually selected in the app}

\item{cov}{covariance matrix for space 1}

\item{covInv}{inverse covariance matrix for space 1}

\item{exp}{reference point in space 1}

\item{space2}{dataframe of variables in linked space}

\item{space2.cov}{covariance matrix for space 2}

\item{space2.covInv}{inverse covariance matrix for space 2}

\item{space2.exp}{reference point in space 2}

\item{user_dist}{user defined distances}

\item{getCoordsSpace1}{function to calculate coordinates in space 1}

\item{getCoordsSpace2}{function to calculate coordinates in space 2}

\item{getScore}{function to calculate scores and bins}
}
\value{
ggplot, plotly or detourr plot depending on settings$plotType
}
\description{
An interface to generate a specific graph seen when using the GUI.
Settings include: metric, linkage, k, plotType, for details
see the vignette on using this function.
}
\examples{
makePlots(space1 = Bikes$space1,
  settings = list(
      plotType = "WC", x="hum", y="temp", k=4, metric="euclidean",
      linkage="ward.D2", WCa=0.5, showalpha=TRUE),cov = cov(Bikes$space1),
      space2 = Bikes$space2, getScore = outsidescore(Bikes$other$res,"Residual"))

makePlots(space1 = Bikes$space1,
  settings = list(
      plotType = "tour", k=4, metric="euclidean", linkage="ward.D2",
      tourspace="space1", colouring="clustering", out_dim=2, tour_path="grand",
      display="scatter",radial_start=NULL, radial_var=NULL, slice_width=NULL, seed = 2025),
      cov = cov(Bikes$space1), space2 = Bikes$space2,
      getScore = outsidescore(Bikes$other$res,"Residual"))

}
