% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ollama_live.R
\name{ensure_only_ollama_model_loaded}
\alias{ensure_only_ollama_model_loaded}
\title{Ensure only one Ollama model is loaded in memory}
\usage{
ensure_only_ollama_model_loaded(model, verbose = TRUE)
}
\arguments{
\item{model}{Character scalar giving the Ollama model name that should
remain loaded (for example \code{"mistral-small3.2:24b"}, \code{"qwen3:32b"},
\code{"gemma3:27b"}). All other models currently reported by
\code{ollama ps} will be candidates for unloading.}

\item{verbose}{Logical; if \code{TRUE} (the default), the function prints
informational messages about the models detected and any unload
operations performed. If \code{FALSE}, the function runs quietly.}
}
\value{
Invisibly returns a character vector containing the names of
models that were requested to be unloaded (i.e., those passed to
\code{ollama stop}). If no models were unloaded, an empty character
vector is returned.
}
\description{
\code{ensure_only_ollama_model_loaded()} is a small convenience helper for
managing memory when working with large local models via Ollama. It
inspects the current set of active models using the \verb{ollama ps} command
and attempts to unload any models that are not the one you specify.
}
\details{
This can be useful when running multiple large models (for example
\code{"mistral-small3.2:24b"}, \code{"qwen3:32b"}, \code{"gemma3:27b"}) on a single
machine, where keeping all of them loaded simultaneously may exhaust
GPU or system memory.

The function is intentionally conservative:
\itemize{
\item If the \code{ollama} command is not available on the system \emph{or}
\verb{ollama ps} returns an error or empty output, no action is taken
and a message is printed when \code{verbose = TRUE}.
\item If no active models are reported, no action is taken.
\item Only models with names different from \code{model} are passed to
\code{ollama stop <name>}.
}

This helper is not called automatically by the package; it is intended
to be used programmatically in development scripts and ad hoc workflows
before running comparisons with \code{\link[=ollama_compare_pair_live]{ollama_compare_pair_live()}} or
\code{\link[=submit_ollama_pairs_live]{submit_ollama_pairs_live()}}.

This function relies on the \code{ollama} command-line interface being
available on the system \code{PATH}. If the command cannot be executed
or returns a non-zero status code, the function will issue a message
(when \code{verbose = TRUE}) and return without making any changes.

The exact output format of \code{ollama ps} is treated as an
implementation detail: this helper assumes that the first non-empty line
is a header and that subsequent non-empty lines begin with the model
name as the first whitespace-separated field. If the format changes in a
future version of Ollama, parsing may fail and the function will simply
fall back to doing nothing.

Because \verb{ollama stop} affects the global Ollama server state for the
current machine, you should only use this helper in environments where
you are comfortable unloading models that might be in use by other
processes.
}
\examples{
\dontrun{
# Keep only mistral-small3.2:24b loaded in Ollama, unloading any
# other active models
ensure_only_ollama_model_loaded("mistral-small3.2:24b")
}

}
\seealso{
\itemize{
\item \code{\link[=ollama_compare_pair_live]{ollama_compare_pair_live()}} for single-pair Ollama comparisons.
\item \code{\link[=submit_ollama_pairs_live]{submit_ollama_pairs_live()}} for row-wise Ollama comparisons across
many pairs.
}
}
