% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_costeffectiveness.R
\name{summary_ice}
\alias{summary_ice}
\title{Summary statistics of the incremental cost-effectiveness plane.}
\usage{
summary_ice(df, e_int, e_comp, c_int, c_comp)
}
\arguments{
\item{df}{a dataframe.}

\item{e_int}{character. Name of variable of the dataframe containing total effects of the intervention strategy.}

\item{e_comp}{character. Name of variable of the dataframe containing total effects of the comparator strategy.}

\item{c_int}{character. Name of variable of the dataframe containing total costs of the intervention strategy.}

\item{c_comp}{character. Name of variable of the dataframe containing total costs of the comparator strategy.}
}
\value{
A dataframe.
}
\description{
This function computes the probability that the probabilistic outcome is in each of the quadrants.
}
\examples{
# Generating statistics of the incremental cost-effectiveness plane using the example data.
data(df_pa)
summary_ice(df = df_pa,
            e_int = "t_qaly_d_int",
            e_comp = "t_qaly_d_comp",
            c_int = "t_costs_d_int",
            c_comp = "t_costs_d_comp"
            )
}
