% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_inspection.R
\name{do_quick_check}
\alias{do_quick_check}
\title{Perform quick checks of inputs and outputs}
\usage{
do_quick_check(
  df,
  v_probs = NULL,
  v_utilities = NULL,
  v_costs = NULL,
  v_hr = NULL,
  v_rr = NULL,
  v_r = NULL,
  v_outcomes = NULL
)
}
\arguments{
\item{df}{a dataframe.}

\item{v_probs}{(a vector of) character. Name of variables containing probabilities.}

\item{v_utilities}{(a vector of) character. Name of the variables containing utility values.}

\item{v_costs}{(a vector of) character. Name of the variables containing cost estimates.}

\item{v_hr}{(a vector of) character. Name of the variables containing hazard ratios.}

\item{v_rr}{(a vector of) character. Name of the variables containing relative risks.}

\item{v_r}{(a vector of) character. Name of the variables containing rates.}

\item{v_outcomes}{(a vector of) character. Name of the variables containing outcomes of the model.}
}
\value{
A matrix.
}
\description{
This function performs multiple checks on user-defined columns.
}
\examples{
# Checking costs and utility values of the example data
\donttest{
do_quick_check(df = df_pa,
               v_utilities = c("u_pfs", "u_pd"),
               v_costs = c("c_pfs", "c_pd")
               )
               }
}
