% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pARIbrain.R
\name{pARIbrain}
\alias{pARIbrain}
\title{Permutation-based All-Resolutions Inference for brain imaging.}
\usage{
pARIbrain(copes, thr=NULL, mask=NULL, alpha=.05, clusters = NULL, 
alternative = "two.sided", summary_stat=c("max", "center-of-mass"),
silent=FALSE, family = "simes", delta = 0, B = 1000, rand = FALSE, 
iterative = FALSE, approx = TRUE, ncomb = 100, step.down = FALSE, max.step = 10, ...)
}
\arguments{
\item{copes}{List of NIfTI file. The list of copes, i.e., contrasts maps, one for each subject used to compute the statistical tests.}

\item{thr}{Numeric value. Threshold used to construct the cluster map. Default to \code{NULL}.}

\item{mask}{NIfTI file or character string. 3D array of logical values (i.e. \code{TRUE/FALSE} in/out of the brain). 
Alternatively it may be a (character) NIfTI file name. If \code{mask=NULL}, it is assumed that none of the voxels have to be excluded.}

\item{alpha}{Numeric value in `[0,1]`. \eqn{\alpha} level to control the family-wise error rate. Default to 0.05.}

\item{clusters}{NIfTI file or character string. 3D array of cluster ids (0 when voxel does not belong to any cluster) or a (character) NIfTI file name. 
If \code{cluster=NULL} the cluster map is computed by the \code{cluster_threshold} function with threshold equals \code{thr}.}

\item{alternative}{Character string. It refers to the alternative hypothesis, must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"lower"}.}

\item{summary_stat}{Character string. Choose among \code{=c("max", "center-of-mass")}.}

\item{silent}{Boolean value. Default to \code{FALSE}. If \code{TRUE} the function prints the results.}

\item{family}{String character. Name of the family confidence envelope to compute the critical vector 
from \code{"simes"}, \code{"aorc"}, \code{"beta"}, \code{"higher.criticism"}, and \code{"power"}.
Default to "simes".}

\item{delta}{Numeric value. \eqn{\delta} value. Please see the reference below. Default to 0.}

\item{B}{Numeric value. Number of permutations, default to 1000.}

\item{rand}{Boolean value. Default to \code{FALSE}. If \code{rand = TRUE}, the \eqn{p}-values are computed by \code{rowRanks}. Please see \code{\link{signTest}}}

\item{iterative}{Boolean value. If \code{iterative = TRUE}, the iterative method is applied (computationally demanding). Default to \code{FALSE}. Please see the reference below.}

\item{approx}{Boolean value. Default to \code{TRUE}. If you are analyzing high dimensional data, we suggest to put \code{approx = TRUE} to speed up the computation time. Please see the reference below.}

\item{ncomb}{Numeric value. If \code{approx = TRUE}, you must decide how many random sub collections (level of approximation) considered. Default to 100.}

\item{step.down}{Boolean value. Default to \code{FALSE} If you want to compute the lambda calibration parameter using the step-down approach put \code{TRUE}. Please see the reference below.}

\item{max.step}{Numeric value. Default to 10. Maximum number of steps for the step down approach, so useful when \code{step.down = TRUE}.}

\item{...}{further arguments. See \code{signTest}.}
}
\value{
A list with elements:
\describe{
 \item{out}{Data.frame containing the size, the number of false null hypotheses, the number of true null hypotheses, the lower bound for the true discovery proportion, and other statistics for each cluster.}
 \item{clusters}{Matrix describing the clusters analyzed.}
}
}
\description{
The main function for All-Resolutions Inference (ARI) method based on the critical vector constructed 
using the \eqn{p}-values permutation distribution. The function computes simultaneous lower bounds for the number of true discoveries 
for each set of hypotheses specified in \code{ix} controlling family-wise error rate at level \code{alpha}.
}
\examples{
\dontrun{
library(remotes)
install_github("angeella/fMRIdata")
library(fMRIdata)
data(Auditory_clusterTH3_2)
data(Auditory_copes)
data(Auditory_mask)
auditory_out <- pARIbrain(copes = Auditory_copes, 
clusters = Auditory_clusterTH3_2, mask = Auditory_mask, 
alpha = 0.05, silent = TRUE)
auditory_out$out
}
}
\references{
For the general framework of All-Resolutions Inference see:

Goeman, Jelle J., and Aldo Solari. "Multiple testing for exploratory research." Statistical Science 26.4 (2011): 584-597.

For All-Resolutions Inference for functional Magnetic Resonance Imaging data see: 

Rosenblatt, Jonathan D., et al. "All-resolutions inference for brain imaging." Neuroimage 181 (2018): 786-796.

For permutation-based All-Resolutions Inference see:

Andreella, A., Hemerik, J., Finos, L., Weeda, W., & Goeman, J. (2023). Permutation-based true discovery proportions for functional magnetic resonance imaging cluster analysis. Statistics in Medicine, 42(14), 2311-2340.
}
\seealso{
\code{\link{signTest}}, \code{\link{lambdaOpt}},  \code{\link{criticalVector}}
}
\author{
Angela Andreella
}
