% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-person.R
\name{orcid_email}
\alias{orcid_email}
\title{Retrieve email information from ORCID}
\usage{
orcid_email(orcid_id, token = NULL)
}
\arguments{
\item{orcid_id}{Character string. A valid ORCID identifier in the format
XXXX-XXXX-XXXX-XXXX. Can also handle URLs like https://orcid.org/XXXX-XXXX-XXXX-XXXX.}

\item{token}{Character string or NULL. API token for authenticated requests.
If NULL (default), checks the ORCID_TOKEN environment variable. Email
addresses usually require authentication.}
}
\value{
A data.table with the following columns:
\describe{
\item{orcid}{ORCID identifier}
\item{email}{Email address}
\item{primary}{Logical indicating if this is the primary email}
\item{verified}{Logical indicating if the email is verified}
\item{visibility}{Visibility setting}
}
Returns an empty data.table with the same structure if no emails
are found or accessible.
}
\description{
Fetches email addresses associated with an ORCID record. Note that email
addresses are typically private and require authentication to access.
}
\details{
This function queries the ORCID public API endpoint:
\code{https://pub.orcid.org/v3.0/{orcid-id}/email}

Email addresses are typically private and will only be returned if you have
appropriate authentication permissions.
}
\examples{
\dontrun{
# Fetch email (requires authentication)
Sys.setenv(ORCID_TOKEN = "your-token-here")
email <- orcid_email("0000-0002-1825-0097")
print(email)
}

}
\references{
ORCID API Documentation: \url{https://info.orcid.org/documentation/api-tutorials/}
}
\seealso{
\code{\link{orcid_person}}
}
