% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_feature.R
\name{perform_feature_selection}
\alias{perform_feature_selection}
\title{Perform Feature Selection}
\usage{
perform_feature_selection(
  group_info,
  features,
  id_col_group,
  id_col_features,
  group_col,
  outlier_col = NULL,
  outlier_vals = c("No"),
  group_vals = c("No", "Yes"),
  method = c("lasso", "elastic_net", "ridge", "boruta"),
  mixture = 0.5,
  penalty_vals = 50,
  seed = 1234,
  output_dir = "output"
)
}
\arguments{
\item{group_info}{A data frame containing group information.}

\item{features}{A data frame containing feature data.}

\item{id_col_group}{Column name in `group_info` to join with `features`.}

\item{id_col_features}{Column name in `features` to join with `group_info`.}

\item{group_col}{Column name indicating the group information.}

\item{outlier_col}{(Optional) Column name for identifying outliers.}

\item{outlier_vals}{(Optional) Values indicating non-outliers.}

\item{group_vals}{A vector of length 2 indicating the values for group comparison.}

\item{method}{The feature selection method to use: "lasso", "elastic_net", "ridge", "boruta".}

\item{mixture}{(Optional) The mixture parameter for Elastic Net, default is 0.5.}

\item{penalty_vals}{(Optional) Number of penalty values to try for tuning, default is 50.}

\item{seed}{(Optional) Random seed for reproducibility, default is 1234.}

\item{output_dir}{(Optional) Directory to save output files, default is "output".}
}
\value{
A tibble containing selected features and variable importances.
}
\description{
This function performs feature selection using various methods such as LASSO, Elastic Net, Ridge regression, and Boruta.
It outputs selected features and variable importance plots.
}
