% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hal_select.R
\docType{methods}
\name{hal_select}
\alias{hal_select}
\alias{hal_select.HALQuery}
\title{Select Fields}
\usage{
hal_select(query, ...)

\method{hal_select}{HALQuery}(query, ...)
}
\arguments{
\item{query}{An object of class \code{HALQuery} (typically returned by \code{\link[=hal_query]{hal_query()}}).}

\item{...}{One or more \code{\link{character}} string separated by commas giving the
fields to be returned.}
}
\value{
An object of class \code{\link[=hal_query]{HALQuery}}.
}
\description{
Select Fields
}
\examples{
## Select fields
hal_query() |> hal_select("label_s")

(q <- hal_query() |> hal_select("halId_s", "uri_s"))

## Update query
hal_select(q, "docType_s")
}
\seealso{
Other query tools: 
\code{\link{hal_facet}()},
\code{\link{hal_filter}()},
\code{\link{hal_group}()},
\code{\link{hal_query}()},
\code{\link{hal_sort}()},
\code{\link{operators}}
}
\author{
N. Frerebeau
}
\concept{query tools}
