% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od.2m.only.mod.R
\name{od.2m.only.mod}
\alias{od.2m.only.mod}
\title{Using the first-order derivative method to identify the optimal sample
allocations for moderation effects in two-level multisite randomized
    trials (MRTs)}
\usage{
od.2m.only.mod(
  icc = NULL,
  r12 = NULL,
  r22m = NULL,
  c1 = NULL,
  c1t = NULL,
  c2 = NULL,
  omega = 0.01,
  Q = 0.5,
  n = NULL,
  p = NULL,
  m = NULL,
  iter = 300,
  binary = TRUE,
  mod.level = 2,
  nlim = c(2, 300),
  plim = c(0.01, 0.99),
  varlim = c(0, 0.005),
  by = c("n", "p"),
  varlab = "Variance",
  nlab = "Level-One Sample Size (n)",
  plab = "Proportion (p)",
  vartitle = ""
)
}
\arguments{
\item{icc}{The unconditional intraclass correlation coefficient (ICC) in population or in
each treatment condition.}

\item{r12}{The proportion of level-1 variance explained by covariates.}

\item{r22m}{The proportion of variance of site-specific treatment
effect explained by covariates.}

\item{c1}{The cost of sampling one level-1 unit in control condition.}

\item{c1t}{The cost of sampling one level-1 unit in treatment condition.}

\item{c2}{The cost of sampling one level-2 unit (site).}

\item{omega}{The standardized variance of site-specific treatment effect.}

\item{Q}{The proportion of units in one group for the binary moderator.
Default is 0.5.}

\item{n}{The level-1 sample size per level-2 unit.}

\item{p}{The proportion of level-1 units within each level 2 unit
to be assigned to treatment.}

\item{m}{The total cost to plot the variance curve. The default value is
the total cost of sampling 60 sites at the optimal allocation.}

\item{iter}{Number of iterations; default value is 100.}

\item{binary}{Logical; The moderator is binary if TRUE, and continuous if
FALSE. The default is TRUE.}

\item{mod.level}{The level of the moderator is at. The moderator is at level 1
if mod.level is 1, and at level 2 if mod.level is 2. The default is
mod.level = 1.}

\item{nlim}{The plot range for n, default value is c(2, 50).}

\item{plim}{The plot range for p, default value is c(0, 1).}

\item{varlim}{The plot range for variance, default value is c(0, 0.05).}

\item{by}{Dimensions to plot power curves by the optimal design parameters.
The default value is by all optimal design parameters for a type of design.
For example, default values are by = "p" for single-level designs,
by = c("n", "p") for two-level designs,
and by = c("n", "p", "J") for three-level designs.}

\item{varlab}{The plot label for variance,
default value is "Variance".}

\item{nlab}{The plot label for \code{n},
default value is "Level-1 Sample Size: n".}

\item{plab}{The plot label for \code{p},
default value is "Proportion Level-1 Units in Treatment: p".}

\item{vartitle}{The title of variance plot, default value is NULL.}
}
\description{
The optimal design of two-level
    MRTs probing moderation effects
    identify the optimal sample allocations.
    The optimal design parameters include
    the level-1 sample size per level-2 unit (\code{n})
    and the proportion of level-1 individuals/units assigned to
    the experimental group (\code{p}).
    This function solves the optimal \code{n} and/or \code{p}
    with and without a constraint using the first-order derivative
    method to minimize the variance of the moderation effect
    estimator. It includes binary or continuous moderators at
    level 2 or level 1.
}
\examples{
myod <- od.2m.only.mod(icc = .2, r12 = .5, r22m = .5,
                       c1 = 10, c1t = 100, c2 = 50, omega = .01)
myod$out
}
