% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_test_plots.R
\name{plot_loadings}
\alias{plot_loadings}
\title{Plot PC index loadings from \code{pca_test} object.}
\usage{
plot_loadings(
  pca_test,
  pc_no = 1,
  violin = FALSE,
  filter_boots = FALSE,
  quantile_threshold = 0.25
)
}
\arguments{
\item{pca_test}{an object of class pca_test_results generated by \code{pca_test}.}

\item{pc_no}{An integer indicating which PC to plot.}

\item{violin}{If TRUE, violin plots are added for the confidence intervals of
the sampling distribution.}

\item{filter_boots}{if TRUE, only bootstrap iterations in which the variable
with the highest median loading is above \code{quantile_threshold}.}

\item{quantile_threshold}{a real value between 0 and 1. Use this to change
the threshold used for filtering bootstrap iterations. The default is 0.25.}
}
\value{
\code{ggplot} object.
}
\description{
Index loadings (Vieira 2012) are presented with confidence intervals on the
sampling distribution generated by bootstrapping and a null distribution
generated by permutation.
}
\details{
If PCs are unstable, there is an option (\code{filter_boots}) to take only the
bootstrap iterations in which the variable with the highest median loading
across all iterations is above \code{quantile_threshold} (default: 0.25). This
helps to reveal reliable connections of this variable with other variables in
the data set.
}
\examples{
  onze_pca <- pca_test(onze_intercepts |> dplyr::select(-speaker), n = 10)
  # Plot PC1
  plot_loadings(onze_pca, pc_no=1)
  # Plot PC2 with violins (not particularly useful in this case!)
  plot_loadings(onze_pca, pc_no=2, violin = TRUE)
}
\references{
Vieira, Vasco (2012): Permutation tests to estimate significances on
Principal Components Analysis. \emph{Computational Ecology and Software} 2.
103–123.
}
