% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_associations.R
\name{cluster_associations}
\alias{cluster_associations}
\title{Cluster association rules}
\usage{
cluster_associations(
  x,
  n,
  by,
  algorithm = "Hartigan-Wong",
  predicates_in_label = 2
)
}
\arguments{
\item{x}{A nugget of flavour \code{associations}, typically the output
of \code{\link[=dig_associations]{dig_associations()}}.}

\item{n}{The number of clusters to create. Must be a positive integer.}

\item{by}{A tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the numeric column to use for clustering.}

\item{algorithm}{The k-means algorithm to use. One of \code{"Hartigan-Wong"}
(the default), \code{"Lloyd"}, \code{"Forgy"}, or \code{"MacQueen"}. See \code{\link[stats:kmeans]{stats::kmeans()}}
for details.}

\item{predicates_in_label}{The number of most common predicates to include
in the cluster label. The default is 2.}
}
\value{
A tibble with one row per cluster. The columns are:
\itemize{
\item \code{cluster}: the cluster number;
\item \code{cluster_label}: a label for the cluster, consisting of the number of rules
in the cluster and the most common predicates in the antecedents of those
rules;
\item \code{consequent}: consequents of the rules;
\item other numeric columns from the input nugget, aggregated by mean within each
cluster.
}
}
\description{
This function clusters association rules based on the selected numeric
attribute \code{by} (e.g., confidence or lift) and summarizes the clusters.
The clustering is performed using the k-means algorithm.
}
\details{
Each cluster is represented by a label consisting of the number of rules
in the cluster and the most common predicates in the antecedents of those
rules.
}
\examples{
# Prepare the data
cars <- mtcars |>
    partition(cyl, vs:gear, .method = "dummy") |>
    partition(carb, .method = "crisp", .breaks = c(0, 3, 10)) |>
    partition(mpg, disp:qsec, .method = "triangle", .breaks = 3)

# Search for associations
rules <- dig_associations(cars,
                          antecedent = everything(),
                          consequent = everything(),
                          max_length = 3,
                          min_support = 0.2,
                          measures = c("lift", "conviction"))

# Cluster the found rules
clu <- cluster_associations(rules, 10, "lift")

\dontrun{
# Plot the clustered rules
library(ggplot2)

ggplot(clu) +
   aes(x = cluster_label, y = consequent, color = lift, size = support) +
   geom_point() +
   xlab("predicates in antecedent groups") +
   scale_y_discrete(limits = rev) +
   theme(axis.text.x = element_text(angle = 45, hjust = 1))
}
}
\seealso{
\code{\link[=dig_associations]{dig_associations()}}, \code{\link[=association_matrix]{association_matrix()}} \code{\link[stats:kmeans]{stats::kmeans()}}
}
\author{
Michal Burda
}
