% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_single_point_extra.R
\name{run_single_point}
\alias{run_single_point}
\title{Run full adaptive single-point PK analysis}
\usage{
run_single_point(
  dat,
  route = c("bolus", "oral", "infusion"),
  half_life = NULL,
  dose_type = NULL,
  pooled_ctrl = pooled_control(),
  ssctrl = ss_control()
)
}
\arguments{
\item{dat}{A data frame containing raw time–concentration data in the
standard nlmixr2 format.}

\item{route}{Character string specifying the route of administration. Must be one of
"bolus", "oral", or "infusion".}

\item{half_life}{Optional numeric value representing the elimination half-life of the drug.
If not provided, half-life is estimated within run_single_point_base() using get_hf() applied
to the pharmacokinetic observations.}

\item{dose_type}{Classified as "first_dose", "repeated_doses", or "combined_doses"
based on whether observed concentrations occur following the first administration,
during repeated dosing, or across both contexts. This parameter is passed directly to
run_single_point_base().}

\item{pooled_ctrl}{A list of pooled-analysis control options created using pooled_control().
These control time binning and time-after-dose rounding when pooled summaries are required.}

\item{ssctrl}{A list of steady-state control options created using ss_control().
These govern assumptions and thresholds used when interpreting steady-state behavior
in single-point logic.}
}
\value{
An object of class "single.point.lst" with results from the base and extended steps.
}
\description{
Runs full adaptive single-point pharmacokinetic analysis to estimate CL, Vd,
and ka across bolus, oral, and infusion dosing scenarios.
}
\examples{
# Example: Adaptive single-point PK analysis for bolus data
# Step 1: Preprocess the data
dat <- Oral_1CPT
out <- processData(dat)
# Step 2: Extract route and dose type info
froute <- out$Datainfo$Value[out$Datainfo$Infometrics == "Dose Route"]
fdose_type <- out$Datainfo$Value[out$Datainfo$Infometrics == "Dose Type"]
# Step 3: Estimate half life
half_life <- get_hf(dat = out$dat)$half_life_median
# Step 4: Run single-point analysis (CL, Vd, Ka if oral)
result <- run_single_point(
  dat = out$dat,
  route = froute,
  dose_type = fdose_type,
  half_life = half_life
)
# Step 5: View results
print(result$singlepoint.results)

}
\seealso{
\code{\link{run_single_point_base}}, \code{\link{run_single_point_extra}}
}
\author{
Zhonghui Huang
}
